package csbase.client.applications.flowapplication.graph;

import java.awt.geom.Point2D;

/**
 * <p>
 * Observador de elemento do grafo.
 * </p>
 * 
 * <p>
 * Observador utilizado para tomar conhecimento de alteres nos elementos do
 * grafo, alteraes como, drag, drop, redimensionamento, mudanas na seleo e
 * parametrizao.
 * </p>
 * 
 * @author lmoreira
 */
public interface GraphElementListener {
  /**
   * Notifica que a conexo se fixou a um arquivo.
   * 
   * @param link A conexo.
   * @param fileDescriptor O arquivo.
   */
  void wasAnchored(GraphLink link, GraphFileDescriptor fileDescriptor);

  /**
   * Notifica que o elemento passo por arrastado (drag) do ponto inicial at o
   * ponto final.
   * 
   * @param element O elemento que foi arrastado.
   * @param startPoint O ponto inicial.
   * @param endPoint O ponto final.
   */
  void wasDragged(GraphElement element, Point2D startPoint, Point2D endPoint);

  /**
   * Notifica que o elemento passado foi deslocado tx para direita e ty para
   * cima.
   * 
   * @param element O elemento que foi arrastado.
   * @param tx O deslocamento em x.
   * @param ty O deslocamento em y.
   */
  void wasDragged(GraphElement element, double tx, double ty);

  /**
   * Notifica que o elemento passado foi largado (drop) no ponto passado.
   * 
   * @param element O elemento que foi arrastado.
   * @param point O ponto.
   */
  void wasDropped(GraphElement element, Point2D point);

  /**
   * Notifica que a aresta passada foi aumentada.
   * 
   * @param link A aresta.
   */
  void wasIncreased(GraphLink link);

  /**
   * Notifica que um parmetro do algoritmo do n foi habilitado/desabilitado.
   * 
   * @param node O n.
   * @param parameterName O nome do parmetro.
   * @param isEnabled Flag que indica se o parmetro foi habilitado (
   *        <code>true</code>) ou desabilitado (<code>false</code>).
   */
  void wasParameterSetEnabled(GraphNode node, String parameterName,
    boolean isEnabled);

  /**
   * Notifica que um parmetro do algoritmo do n foi habilitado/desabilitado.
   * 
   * @param node O n.
   * @param parameterName O nome do parmetro.
   * @param isVisible Flag que indica se o parmetro est visvel (
   *        <code>true</code>) ou no (<code>false</code>).
   */
  void wasParameterSetVisible(GraphNode node, String parameterName,
    boolean isVisible);

  /**
   * Notifica que o elemento foi parametrizado.
   * 
   * @param element O elemento que foi parametrizado.
   */
  void wasParametrized(GraphElement element);

  /**
   * Notifica que o n foi renomeado.
   * 
   * @param node O n que foi renomeado.
   */
  void wasRenamed(GraphNode node);

  /**
   * Notifica que o n foi redimensionado.
   * 
   * @param node O n que foi redimensionado.
   */
  void wasResized(GraphNode node);

  /**
   * Notifica que houve mudana na seleo do elemento, ou seja, ele foi
   * selecionado ou foi desselecionado.
   * 
   * @param element O elemento.
   */
  void wasSelected(GraphElement element);

  /**
   * Notifica que a conexo perdeu um de seus arquivos, onde ela se fixava.
   * 
   * @param link A conexo.
   * @param fileDescriptor O arquivo.
   */
  void wasUnanchored(GraphLink link, GraphFileDescriptor fileDescriptor);

  /**
   * Notifica de link mudou de estado.
   * 
   * @param link link
   */
  void wasLinkStatusChanged(GraphLink link);
}
