package csbase.client.applications.flowapplication.graph;

import java.awt.geom.Point2D;

public interface GraphListener {
  void wasChangedWorkspace(Graph graph);

  void wasElementCreated(Graph graph, GraphElement element);

  void wasElementDragged(Graph graph, GraphElement element, Point2D startPoint,
    Point2D endPoint);

  void wasElementDragged(Graph graph, GraphElement element, double tx, double ty);

  void wasElementDropped(Graph graph, GraphElement element, Point2D point);

  void wasElementParametrized(Graph graph, GraphElement element);

  void wasElementRemoved(Graph graph, GraphElement element);

  void wasElementSelected(Graph graph, GraphElement element);

  void wasLinkIncreased(Graph graph, GraphLink link);

  void wasLinkStatusChanged(Graph graph, GraphLink link);

  void wasLinkAnchored(Graph graph, GraphLink link,
    GraphFileDescriptor fileDescriptor);

  void wasLinkUnanchored(Graph graph, GraphLink link,
    GraphFileDescriptor fileDescriptor);

  void wasNodeResized(Graph graph, GraphNode node);

  void wasParameterSetEnabled(Graph graph, GraphNode node,
    String parameterName, boolean isEnabled);

  void wasReseted(Graph graph);

  void wasParameterSetVisible(Graph graph, GraphNode node,
    String parameterName, boolean isVisible);
}
