package csbase.client.applications.projectsmanager.models;

import csbase.logic.User;

/**
 * Estrutura que armazena informaes especficas de ocupao de projetos por
 * usurio.
 * 
 * @author jnlopes
 * 
 */
public class ProjectSpecificAreaOccupationData {

  /**
   * Usurios que possuem projetos.
   */
  private User[] users;

  /**
   * Espaos ocupados por usurios.
   */
  private Double[] spaceByUser;

  /**
   * Construtor
   * 
   * @param users Usurios que possuem projetos.
   * @param spaceByUser Espaos ocupados por usurios.
   */
  public ProjectSpecificAreaOccupationData(final User[] users,
    final Double[] spaceByUser) {
    this.users = users;
    this.spaceByUser = spaceByUser;
  }

  /**
   * Retorna os usurios que possuem projetos.
   * 
   * @return Usurios que possuem projetos.
   */
  public User[] getUsers() {
    return users;
  }

  /**
   * Retorna os espaos ocupados por usurios.
   * 
   * @return Espaos ocupados por usurios.
   */
  public Double[] getSpaceByUser() {
    return spaceByUser;
  }

}
