package csbase.client.applications.serverdiagnostic;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;

/**
 * Aplicao que exibe informaes para diagnosticar o estado do servidor.
 * 
 * @author Tecgraf PUC-Rio
 */
public class ServerDiagnostic extends Application {

  /**
   * Identificador do aplicativo.
   */
  final public static String ID = "serverdiagnostic";

  /**
   * Painel principal da aplicao
   */
  private ServerDiagnosticPanel mainPanel;

  /**
   * Tarefa que requista ao servidor as informaes de diagnstico
   */
  private ServerDiagnosticUpdateTask task;

  /**
   * Construtor.
   * 
   * @param id identificador da aplicao
   */
  public ServerDiagnostic(String id) {
    super(id);
    this.task = new ServerDiagnosticUpdateTask(this);
    if (task.execute()) {
      mainPanel = new ServerDiagnosticPanel(this, task.getResult());
      buildInterface();
    }
  }

  /**
   * Obtm a tarefa que requisita as informaes de diagnstico ao servidor.
   * 
   * @return a tarefa que obtm os dados de diagnstico
   */
  public ServerDiagnosticUpdateTask getTask() {
    return this.task;
  }

  /** Constroi a interface da aplicao. */
  private void buildInterface() {
    ApplicationFrame appFrame = getApplicationFrame();
    appFrame.add(mainPanel);
    appFrame.pack();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void killApplication() throws ApplicationException {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean userCanKillApplication() {
    return true;
  }

}
