package csbase.client.applications.sgamonitor.columns;

import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;

/**
 * Coluna que exibe o nmero de ns ocupados de um cluster. <br/>
 * Classificamos um n como 'ocupado' quando:<br/>
 * 1 - N est vivo; <br/>
 * 2 - O nmero de jobs em execuo no n  igual ao nmero de processadores.
 * 
 * @author Tecgraf
 */
public class BusyColumn extends AbstractConfigurableColumn<SGASet> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   * @param visible - visibilidade da coluna.
   * @param stringProvider - utilizado para obter o nome da coluna
   *        internacionalizada.
   * @param align - alinhamento da coluna.
   */

  public BusyColumn(String id, Boolean visible, IStringProvider stringProvider,
    Integer align) {
    super(id, visible, stringProvider, align);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return Integer.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getString(getId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(SGASet obj) {

    int count = 0;
    for (SGAInfo node : obj.getAllInfo()) {
      if (node.getAlive() && node.getNumberOfJobs() == node.getNumProcessors()) {
        count++;
      }
    }

    return count;
  }

}
