/*
 * $Id$
 */
package csbase.client.util.gui.log.actions;

import javax.swing.JComponent;

import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.actions.core.AbstractLogFileAction;

/**
 * Define o tempo da auto-recarga.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class SetAutoReloadTimeAction extends AbstractLogFileAction {

  /**
   * Tempo (segundos) do reload automtico.
   */
  private final long timeSec;

  /**
   * Construtor
   * 
   * @param logPanel o painel de log
   * @param timeSec o tempo de reload (em segundos)
   */
  public SetAutoReloadTimeAction(final LogPanel logPanel, final long timeSec) {
    super(logPanel);
    this.timeSec = timeSec;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) throws Exception {
    getLogPanel().getReloader().setTime(timeSec);
  }
}