package csbase.client.algorithms.parameters;

import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;

import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;

/**
 * Tarefa responsvel por carregar os parmetros gerados pelo algoritmo Extrator
 * no configurador.
 */
public class ParameterLoaderTask extends RemoteTask<String> {

  /** A janela da aplicao (para mensagens de erro). */
  private Window window;

  /** A viso do componente do carregagor. */
  private ParameterLoaderView parameter;

  /** Arquivo gerado pelo algoritmo extrator. */
  private ClientProjectFile file = null;

  /**
   * Construtor.
   * 
   * @param window A janela da aplicao.
   * @param parameter A viso do componente do carregagor.
   */
  public ParameterLoaderTask(Window window, ParameterLoaderView parameter) {
    this.window = window;
    this.parameter = parameter;
  }

  /**
   * Cancela a tarefa. Remove o arquivo temporrio que foi criado.
   */
  @Override
  protected void cancelTask() {
    super.cancelTask();
    try {
      // Apagar arquivos de parmetros
      file.remove();
    }
    catch (Exception e) {
      StandardErrorDialogs.showExceptionDialog(window,
        LNG.get("ParameterLoaderView.error.title"), e);
    }
  }

  /**
   * Executa a tarefa.
   * 
   * @throws Exception em caso de falha.
   */
  @Override
  protected void performTask() throws Exception {
    String outputExtractFileName = parameter.getOutputExtractFileName();

    CommonClientProject currentProject =
      DesktopFrame.getInstance().getProject();
    ClientProjectFile rootFile = currentProject.getRoot();
    file = rootFile.getChild(outputExtractFileName);
    if (file == null) {
      throw new FileNotFoundException(String.format(
        LNG.get("ParameterLoaderView.file_not_found.error"),
        outputExtractFileName));
    }
    Reader reader = null;
    try {
      reader = new InputStreamReader(file.getInputStream());
      StringBuilder fileContents = new StringBuilder();

      int character = reader.read();
      while (character != -1) {
        fileContents.append((char) character);
        character = reader.read();
      }
      setResult(fileContents.toString());
    }
    finally {
      FileUtils.close(reader);
      file.remove();
    }
  }

  /**
   * Exibe mensagem de erro com exceo.
   * 
   * @param error exceo
   */
  @Override
  protected void handleError(Exception error) {
    StandardErrorDialogs.showExceptionDialog(window,
      LNG.get("ParameterLoaderView.error.title"), error);
  }
}
