package csbase.client.applications.algorithmsmanager.report.core;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import tecgraf.javautils.gui.GBC;

/**
 * 
 * Dilogo para seleo dos testes que devem ser rodados
 *
 * @author Tecgraf/PUC-Rio
 */
public class TestSelectionDialog extends BasicTestDialog {

  /** Lista de checkBoxes das opes */
  private final List<JCheckBox> checkBoxes = new ArrayList<>();

  /** Indica de clicou ok ou cancelou */
  private boolean clickedOk = false;

  /**
   * Constri o dilogo
   * 
   * @param tests lista de testes.
   * @param locale Locale para os textos.
   * @param parentWindow Janela que disparou esta janela.
   */
  public TestSelectionDialog(List<ITest<?>> tests, Locale locale,
    Window parentWindow) {
    super(locale, parentWindow);
    setModalityType(ModalityType.APPLICATION_MODAL);
    setTitle(getString("title"));

    // Opes
    JPanel checkBoxPanel = new JPanel(new GridBagLayout());
    int y = 0;
    for (ITest<?> test : tests) {
      JCheckBox checkBox = new JCheckBox(test.getName());
      checkBoxes.add(checkBox);
      checkBox.setToolTipText(test.getDescription());
      checkBox.setSelected(true);
      checkBoxPanel.add(checkBox, new GBC(0, y).insets(6, 11, 6, 11)
        .horizontal());
      y++;
    }

    // Botes
    JButton okButton = new JButton(getString("ok.button"));
    okButton.addActionListener(new ActionListener() {

      @Override
      public void actionPerformed(ActionEvent e) {
        clickedOk = true;
        dispose();
      }
    });

    JButton cancelButton = new JButton(getString("cancel.button"));
    cancelButton.addActionListener(new ActionListener() {

      @Override
      public void actionPerformed(ActionEvent e) {
        dispose();
      }
    });

    // Composio
    JScrollPane scroll = new JScrollPane(checkBoxPanel);
    JPanel buttonsPanel = new JPanel(new GridBagLayout());
    buttonsPanel.add(cancelButton, new GBC(0, 0).none().east().insets(11, 11,
      11, 11));
    buttonsPanel.add(okButton, new GBC(1, 0).none().east().insets(11, 11, 11,
      11));

    this.getContentPane().setLayout(new GridBagLayout());
    this.getContentPane().add(scroll, new GBC(0, 0).both());
    this.getContentPane().add(buttonsPanel, new GBC(0, 1).horizontal());
    pack();
    setLocationRelativeTo(parentWindow);
  }

  /**
   * Obtm a seleo
   * 
   * @return Lista com mesmo tamanho da lista de testes passado no construtor
   *         indicando com verdadeiro ou falso se o teste foi selecionado
   */
  public List<Boolean> getSelection() {

    List<Boolean> selection = new ArrayList<>();

    if (!clickedOk) {
      return null;
    }

    for (JCheckBox checkBox : checkBoxes) {

      if (clickedOk && checkBox.isSelected()) {
        selection.add(true);
      }
      else {
        selection.add(false);
      }
    }

    return selection;
  }

}
