package csbase.client.util.xmlpanel;

import java.net.URL;

import javax.swing.ImageIcon;

/**
 * Imagens padro dos paineis.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class XMLPanelImages {

  /**
   * cone: raiz
   */
  public static final ImageIcon ICON_TREE_ROOT = getIcon("root");

  /**
   * cone: folha
   */
  public static final ImageIcon ICON_TREE_LEAF = getIcon("leaf");

  /**
   * cone: normal
   */
  public static final ImageIcon ICON_TREE_NORMAL = getIcon("normal");

  /**
   * Busca uma imagem.
   * 
   * @param name nome para montar o caminho dentro do diretrio de imagens.
   * @return a imagem
   */
  final static private ImageIcon getIcon(final String name) {
    final String imgPath = "images/" + name + ".16.gif";
    final URL url = XMLPanelImages.class.getResource(imgPath);
    if (url == null) {
      return null;
    }
    return new ImageIcon(url);
  }
}
