package csbase.client.applications.fileexchanger.actions;

import java.util.ArrayList;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.actions.core.FileExchangerAction;
import csbase.client.applications.fileexchanger.logic.Exchange;

/**
 * @author Tecgraf/PUC-Rio
 */
public class StartAction extends FileExchangerAction {

  /**
   * Construtor
   * 
   * @param fileExchanger a aplicao.
   */
  public StartAction(FileExchanger fileExchanger) {
    super(fileExchanger, ApplicationImages.ICON_PLAY_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() {
    final FileExchanger fileExchanger = getApplication();
    final ApplicationFrame frame = fileExchanger.getApplicationFrame();
    final ArrayList<Exchange> sels = fileExchanger.getSelectedExchangeList();
    if (sels.size() == 0) {
      final String title = getApplication().getName();
      final String err = getClassString("no.selection.error");
      StandardDialogs.showErrorDialog(frame, title, err);
      return;
    }

    for (Exchange sel : sels) {
      sel.start();
    }
  }

}
