package csbase.client.applications.flowapplication.actions;

import java.awt.geom.Point2D;

import javax.swing.ImageIcon;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphFileDescriptor;
import csbase.client.applications.flowapplication.graph.GraphLink;
import csbase.client.applications.flowapplication.graph.GraphListener;
import csbase.client.applications.flowapplication.graph.GraphNode;

/**
 * Base para as aes da aplicao Construtor de Fluxos. Implementa um adaptador
 * para o listener do grafo do editor de fluxo e mantm uma referncia para a
 * aplicao.
 * 
 */
public abstract class FlowApplicationAction extends
  AbstractSimpleApplicationAction<FlowApplication> implements GraphListener {

  /**
   * Construtor.
   * 
   * @param application A aplicao.
   * @param icon O cone da ao.
   */
  protected FlowApplicationAction(FlowApplication application, ImageIcon icon) {
    super(application, icon);
    application.getWorkspace().getGraph().addGraphListener(this);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementParametrized(Graph graph, GraphElement element) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementCreated(Graph graph, GraphElement element) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementDragged(Graph graph, GraphElement element,
    Point2D startPoint, Point2D endPoint) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementDragged(Graph graph, GraphElement element, double tx,
    double ty) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementDropped(Graph graph, GraphElement element, Point2D point) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementRemoved(Graph graph, GraphElement element) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementSelected(Graph graph, GraphElement element) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasLinkAnchored(Graph graph, GraphLink link,
    GraphFileDescriptor fileDescriptor) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasLinkIncreased(Graph graph, GraphLink link) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasLinkStatusChanged(Graph graph, GraphLink link) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasLinkUnanchored(Graph graph, GraphLink link,
    GraphFileDescriptor fileDescriptor) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasChangedWorkspace(Graph graph) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasNodeResized(Graph graph, GraphNode node) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasParameterSetEnabled(Graph graph, GraphNode node,
    String parameterName, boolean isEnabled) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasParameterSetVisible(Graph graph, GraphNode node,
    String parameterName, boolean isVisible) {
    // implementao vazia para servir de adaptador de GraphListener
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasReseted(Graph graph) {
    // implementao vazia para servir de adaptador de GraphListener
  }
}
