/**
 * $Id: AbstractProjectManagerInfoPanel.java 91193 2009-05-06 17:24:04Z costa $
 */

package csbase.client.applications.projectsmanager.panels;

import csbase.client.applications.projectsmanager.ProjectsManager;

/**
 * Classe abstrata para o painel de informaes detalhadas.
 * 
 * @author Tecgraf
 */
abstract class AbstractProjectManagerInfoPanel extends ProjectsManagerPanel {

  /**
   * Construtor.
   * 
   * @param projectsManager referncia para a aplicao de gerenciamento de
   *        projetos
   */
  public AbstractProjectManagerInfoPanel(final ProjectsManager projectsManager) {
    super(projectsManager);
    initComponents();
    buildPanel();
  }

  /**
   * Atualiza o contedo dos campos em funo dos projetos selecionados.
   */
  abstract void updateFields();

  /**
   * Limpa os campos do painel.
   */
  public abstract void clearFields();

  /**
   * Inicializa os componentes.
   */
  abstract void initComponents();

  /**
   * Constri o painel.
   */
  abstract void buildPanel();
}