/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.algorithmsmanager.actions.AlgorithmManagementAction;
import csbase.client.applications.algorithmsmanager.actions.CommonManagementAction;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmBasicInfoPanel;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmCategoryInfoPanel;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmHistoryInfoPanel;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmVersionInfoPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonEditTabbedPanel;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;
import javax.swing.JPanel;

public class AlgorithmEditDataPanel
extends CommonEditTabbedPanel {
    private AlgorithmBasicInfoPanel infoPanel;
    private AlgorithmCategoryInfoPanel categoryPanel;
    private AlgorithmVersionInfoPanel versionPanel;
    private AlgorithmListItem selectedAlgorithm;
    private AlgorithmHistoryInfoPanel historyPanel;

    public AlgorithmEditDataPanel(CommonManagementAction action) {
        super(action);
    }

    public AlgorithmManagementAction getAlgorithmManagementAction() {
        return (AlgorithmManagementAction)this.getAction();
    }

    @Override
    public boolean confirmDataChanged() {
        if (this.infoPanel.wasModified() || this.categoryPanel.wasModified() || this.versionPanel.wasModified()) {
            return this.confirmCancelling();
        }
        return true;
    }

    public void changeAlgorithmItemEdition(AlgorithmListItem algoItem) {
        this.selectedAlgorithm = algoItem;
        this.initializeData();
    }

    public AlgorithmListItem getSelectedAlgorithm() {
        return this.selectedAlgorithm;
    }

    public AlgorithmCategoryInfoPanel getCategoryPanel() {
        return this.categoryPanel;
    }

    public AlgorithmHistoryInfoPanel getHistoryPanel() {
        return this.historyPanel;
    }

    public AlgorithmBasicInfoPanel getBasicInfoPanel() {
        return this.infoPanel;
    }

    public AlgorithmVersionInfoPanel getVersionPanel() {
        return this.versionPanel;
    }

    @Override
    protected void buildAdditionalInfoPanel() {
        this.categoryPanel = new AlgorithmCategoryInfoPanel(this);
        this.versionPanel = new AlgorithmVersionInfoPanel(this);
        this.historyPanel = new AlgorithmHistoryInfoPanel(this);
        this.addInfoPanel(this.categoryPanel.getTitle(), this.categoryPanel);
        this.addInfoPanel(this.versionPanel.getTitle(), this.versionPanel);
        this.addInfoPanel(this.historyPanel.getTitle(), this.historyPanel);
    }

    @Override
    protected JPanel buildBasicInfoPanel() {
        this.infoPanel = new AlgorithmBasicInfoPanel(this);
        return this.infoPanel;
    }

    @Override
    public void initializeData() {
        this.infoPanel.initializeData();
        this.categoryPanel.initializeData();
        this.versionPanel.initializeData();
        this.historyPanel.initializeData();
    }

    @Override
    protected void handleAlgorithmUpdated(AlgorithmInfo algoInfo) {
        if (this.selectedAlgorithm != null) {
            this.selectedAlgorithm.setItem(algoInfo);
        }
        this.infoPanel.initializeData();
        this.historyPanel.initializeData();
        this.versionPanel.initializeData();
        this.categoryPanel.initializeData();
        this.versionPanel.handleAlgorithmUpdated(algoInfo);
    }

    @Override
    protected void handleCategoryUpdated(CategorySet modifiedCategorySet) {
        this.initializeData();
    }

    @Override
    protected void handleCategoryCreated(Category category) {
        this.initializeData();
    }

    @Override
    protected void handleCategoryRemoved(Category category) {
        this.initializeData();
    }
}

