/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.core;

import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ITest;
import csbase.client.applications.algorithmsmanager.report.core.ITestResult;
import csbase.client.applications.algorithmsmanager.report.core.TestResult;
import java.awt.Window;
import java.util.List;
import tecgraf.javautils.gui.Task;

public abstract class AbstractTest<T>
implements ITest<T> {
    private final Window taskParentWindow;
    private final String taskTitle;
    private final String taskMessage;

    public AbstractTest(Window taskParentWindow, String taskTitle, String taskMessage) {
        this.taskParentWindow = taskParentWindow;
        this.taskTitle = taskTitle;
        this.taskMessage = taskMessage;
    }

    @Override
    public ITestResult<T> run(final Iterable<T> subjects) {
        Task task = new Task<ITestResult<T>>(){

            protected void performTask() throws Exception {
                TestResult result = new TestResult();
                for (Object subject : subjects) {
                    List messages = AbstractTest.this.doTest(subject);
                    result.addMessages(messages);
                }
                this.setResult(result);
            }
        };
        task.execute(this.getTaskParentWindow(), this.getTaskTitle(), this.getTaskMessage());
        return (ITestResult)task.getResult();
    }

    protected Window getTaskParentWindow() {
        return this.taskParentWindow;
    }

    protected String getTaskTitle() {
        return this.taskTitle;
    }

    protected String getTaskMessage() {
        return this.taskMessage;
    }

    protected abstract List<IResultMessage<T>> doTest(T var1);
}

