/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient.dialogs;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.dialogs.core.FileTransferClientFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferPredefinedConnection;
import csbase.logic.filetransferservice.FileTransferProtocol;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import tecgraf.javautils.gui.ComboUtil;
import tecgraf.javautils.gui.GUIUtils;

public class ConnectionFrame
extends FileTransferClientFrame {
    private final JTextField userText = new JTextField(25);
    private final JTextField serverText = new JTextField(25);
    private final JPasswordField passwdHiddenText = new JPasswordField(25);
    private final JComboBox protocolList = new JComboBox();

    @Override
    protected void frameStopped() {
        this.passwdHiddenText.setText(null);
    }

    private void connect() {
        FileTransferClient application = this.getApplication();
        String serverName = this.serverText.getText();
        String userName = this.userText.getText();
        String passwd = this.passwdHiddenText.getText();
        if (FileTransferClientUI.isEmptyString(userName)) {
            String err = this.getString("no.user.error");
            application.showError(err);
            return;
        }
        if (FileTransferClientUI.isEmptyString(serverName)) {
            String err = this.getString("no.server.error");
            application.showError(err);
            return;
        }
        if (FileTransferClientUI.isEmptyString(passwd)) {
            String err = this.getString("no.password.error");
            application.showError(err);
            return;
        }
        User loggedUser = User.getLoggedUser();
        Object userId = loggedUser.getId();
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        CommonClientProject project = desktopFrame.getProject();
        Object projectId = project.getId();
        FileTransferProtocol protocol = (FileTransferProtocol)this.protocolList.getSelectedItem();
        FileTransferConnection conn = new FileTransferConnection(protocol, serverName, userName, passwd, userId, projectId, null);
        FileTransferProxy proxy = application.getServiceProxy();
        if (!proxy.checkConnection(conn)) {
            String fmt = this.getString("connection.failure.error");
            String err = String.format(fmt, userName, serverName);
            application.showError(err);
            application.setConnection(null);
            return;
        }
        application.setConnection(conn);
        this.stop();
    }

    @Override
    protected final JPanel buildPanel(FileTransferClient ftpClient) {
        JPanel mainPanel = this.buildMainPanel(ftpClient);
        JPanel buttonsPanel = this.buildButtonsPanel(ftpClient);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)mainPanel, "Center");
        panel.add((Component)buttonsPanel, "South");
        return panel;
    }

    private JPanel buildButtonsPanel(FileTransferClient ftpClient) {
        JButton closeButton = new JButton();
        closeButton.setText(this.getString("close.button"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConnectionFrame.this.stop();
            }
        });
        JButton connButton = new JButton();
        connButton.setText(this.getString("connect.button"));
        connButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConnectionFrame.this.connect();
            }
        });
        JComponent[] buttons = new JComponent[]{closeButton, connButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        JRootPane root = this.getRootPane();
        root.setDefaultButton(connButton);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1));
        panel.add(connButton);
        panel.add(closeButton);
        return panel;
    }

    private JPanel buildMainPanel(FileTransferClient app) {
        JLabel userLabel = new JLabel(this.getString("user.label"));
        JLabel serverLabel = new JLabel(this.getString("server.label"));
        JLabel passwdLabel = new JLabel(this.getString("password.label"));
        JLabel protocolLabel = new JLabel(this.getString("protocol.label"));
        JButton serverButton = new JButton();
        serverButton.setIcon(FileTransferClientUI.FAST_CONNECT_ICON);
        GUIUtils.trimImageButton((AbstractButton)serverButton);
        serverButton.setToolTipText(this.getString("choose.server.tooltip"));
        serverButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                ConnectionFrame.this.choosePredefinedServer();
            }
        });
        FileTransferProtocol[] protocols = FileTransferProtocol.values();
        DefaultComboBoxModel<FileTransferProtocol> model = new DefaultComboBoxModel<FileTransferProtocol>(protocols);
        this.protocolList.setModel(model);
        this.protocolList.setSelectedItem(FileTransferProtocol.SFTP);
        JComponent[][] cmps = new JComponent[][]{{serverLabel, this.serverText, serverButton}, {protocolLabel, this.protocolList}, {userLabel, this.userText}, {passwdLabel, this.passwdHiddenText}};
        JPanel panel = GUIUtils.createBasicGridPanel((JComponent[][])cmps);
        return panel;
    }

    private void choosePredefinedServer() {
        FileTransferClient application = this.getApplication();
        ApplicationFrame frame = application.getApplicationFrame();
        String labelStr = this.getString("choose.server.label");
        String title = this.getString("choose.server.title");
        JComboBox combo = new JComboBox();
        JLabel label = new JLabel(labelStr);
        JComponent[][] cmps = new JComponent[][]{{label, combo}};
        JPanel panel = GUIUtils.createBasicGridPanel((JComponent[][])cmps);
        List<FileTransferPredefinedConnection> predefs = application.getPredefinedConnections();
        ArrayList<String> serversNames = new ArrayList<String>();
        for (FileTransferPredefinedConnection predef : predefs) {
            String srvName = predef.getServerName();
            serversNames.add(srvName);
        }
        ComboUtil.updateFromList(combo, serversNames, (int)0);
        int option = JOptionPane.showOptionDialog(frame, panel, title, 2, -1, null, null, null);
        if (option == 2 || option == -1) {
            return;
        }
        String selectedServerName = (String)combo.getSelectedItem();
        if (selectedServerName == null) {
            return;
        }
        this.serverText.setText(selectedServerName);
    }

    public ConnectionFrame(FileTransferClient application) {
        super(application);
        this.setResizable(false);
    }
}

