/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.imageviewer.effects;

import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.effects.AbstractEffect;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tecgraf.javautils.gui.GUIUtils;

public class BlurEffect
extends AbstractEffect {
    final JSlider intensitySlider = new JSlider(0);

    public BlurEffect(ImageViewer application) {
        super(application);
        this.intensitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (BlurEffect.this.intensitySlider.isEnabled()) {
                    BlurEffect.this.updatePreview();
                }
            }
        });
    }

    @Override
    public JPanel getParameterPanel() {
        JLabel intensityLabel = new JLabel(this.getString("BlurEffect.intensity.label"));
        JComponent[][] row = new JComponent[][]{{intensityLabel, this.intensitySlider}};
        return GUIUtils.createBasicGridPanel((JComponent[][])row);
    }

    @Override
    protected BufferedImage transformImage(BufferedImage image) {
        return new GaussOperator(this.intensitySlider.getValue()).filter(image, null);
    }

    @Override
    public void resetParameters() {
        this.intensitySlider.setValue(0);
    }

    class GaussOperator
    extends AbstractMatrixFilter
    implements BufferedImageOp {
        private final double intensityFactor;

        GaussOperator(int intensity) {
            if (intensity < 0 || intensity > 100) {
                throw new IllegalArgumentException("Intensidade deve ser de 0 a 100");
            }
            this.intensityFactor = (double)intensity / 100.0;
        }

        private BufferedImage applyGaussOp(BufferedImage src, BufferedImage dest) {
            Raster raster = src.getData();
            int width = raster.getWidth();
            int height = raster.getHeight();
            if (dest == null) {
                dest = new BufferedImage(width, height, src.getType());
            }
            WritableRaster writableRaster = dest.getRaster();
            double max = 0.0;
            int numComponents = src.getColorModel().getNumColorComponents();
            AbstractMatrixFilter.Matrix gaussMatrix = this.gaussMatrixFromIntensity(this.intensityFactor);
            for (int x = 1; x < width - 1; ++x) {
                for (int y = 1; y < height - 1; ++y) {
                    double[] components = new double[numComponents];
                    for (int c = 0; c < components.length; ++c) {
                        AbstractMatrixFilter.Matrix rasterMatrix = this.matrixFrom(raster, c, x, y, gaussMatrix.getRowNum());
                        AbstractMatrixFilter.Matrix multResult = rasterMatrix.multiply(gaussMatrix);
                        components[c] = multResult.sumValues();
                    }
                    writableRaster.setPixel(x, y, components);
                }
            }
            return dest;
        }

        private AbstractMatrixFilter.Matrix gaussMatrixFromIntensity(double intensityFactor) {
            int y;
            int x;
            double[][] matrixRet = new double[3][];
            for (int x2 = 0; x2 < matrixRet.length; ++x2) {
                matrixRet[x2] = new double[matrixRet.length];
                for (int y2 = 0; y2 < matrixRet.length; ++y2) {
                    matrixRet[x2][y2] = 1.0;
                }
            }
            double[] dArray = matrixRet[1];
            dArray[1] = dArray[1] * (1.0 - intensityFactor);
            double[] dArray2 = matrixRet[0];
            dArray2[1] = dArray2[1] * intensityFactor;
            double[] dArray3 = matrixRet[1];
            dArray3[0] = dArray3[0] * intensityFactor;
            double[] dArray4 = matrixRet[1];
            dArray4[2] = dArray4[2] * intensityFactor;
            double[] dArray5 = matrixRet[2];
            dArray5[1] = dArray5[1] * intensityFactor;
            double[] dArray6 = matrixRet[0];
            dArray6[0] = dArray6[0] * (intensityFactor * intensityFactor);
            double[] dArray7 = matrixRet[0];
            dArray7[2] = dArray7[2] * (intensityFactor * intensityFactor);
            double[] dArray8 = matrixRet[2];
            dArray8[0] = dArray8[0] * (intensityFactor * intensityFactor);
            double[] dArray9 = matrixRet[2];
            dArray9[2] = dArray9[2] * (intensityFactor * intensityFactor);
            double sum = 0.0;
            for (x = 0; x < matrixRet.length; ++x) {
                for (y = 0; y < matrixRet.length; ++y) {
                    sum += matrixRet[x][y];
                }
            }
            for (x = 0; x < matrixRet.length; ++x) {
                y = 0;
                while (y < matrixRet.length) {
                    double[] dArray10 = matrixRet[x];
                    int n = y++;
                    dArray10[n] = dArray10[n] / sum;
                }
            }
            return (AbstractMatrixFilter)this.new AbstractMatrixFilter.Matrix(matrixRet);
        }

        @Override
        public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
            return null;
        }

        @Override
        public BufferedImage filter(BufferedImage src, BufferedImage dest) {
            return this.applyGaussOp(src, dest);
        }

        @Override
        public Rectangle2D getBounds2D(BufferedImage src) {
            return null;
        }

        @Override
        public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
            return null;
        }

        @Override
        public RenderingHints getRenderingHints() {
            return null;
        }
    }

    abstract class AbstractMatrixFilter {
        AbstractMatrixFilter() {
        }

        private void squarenessCheck(double[][] shouldBeSquaredMatrix) {
            int matrixTotalColumns = shouldBeSquaredMatrix.length;
            for (int i = 0; i < matrixTotalColumns; ++i) {
                int matrixTotalRows = shouldBeSquaredMatrix[i].length;
                if (matrixTotalColumns == matrixTotalRows) continue;
                throw new IllegalArgumentException("Vetor 2D passado n\u00e3o \u00e9 quadrada");
            }
        }

        protected Matrix matrixFrom(Raster raster, int componentIndex, int x, int y, int totalRowCol) {
            Matrix resultMatrix = new Matrix(totalRowCol);
            int edgeOffset = (totalRowCol - 1) / 2;
            int xOffset = -edgeOffset;
            for (int mx = 0; mx < totalRowCol; ++mx) {
                int yOffset = -edgeOffset;
                for (int my = 0; my < totalRowCol; ++my) {
                    resultMatrix.setValue(mx, my, raster.getSampleDouble(xOffset + x, yOffset + y, componentIndex));
                    ++yOffset;
                }
                ++xOffset;
            }
            return resultMatrix;
        }

        private void borderPixelCheck(Raster raster, int x, int y, Matrix matrix) {
            int edgeOffset = (matrix.getRowNum() - 1) / 2;
            if (x - edgeOffset < 0 || y - edgeOffset < 0 || x + edgeOffset >= raster.getWidth() || y + edgeOffset >= raster.getHeight()) {
                throw new IllegalArgumentException("Pixel passado na borda do raster e este m\u00e9todo n\u00e3o suporta valores de pixel na borda");
            }
        }

        class Matrix {
            private final double[][] matrix2dArray;

            Matrix(int oddRowsCols) {
                if (oddRowsCols % 2 == 0) {
                    this.throwNotOddNumberIllegalArgumentException();
                }
                this.matrix2dArray = this.newSquared2dArray(oddRowsCols);
            }

            Matrix(double[][] matrix2d) {
                AbstractMatrixFilter.this.squarenessCheck(matrix2d);
                if (!this.oddRowCheck(matrix2d) || !this.oddColumnCheck(matrix2d)) {
                    this.throwNotOddNumberIllegalArgumentException();
                }
                this.matrix2dArray = matrix2d;
            }

            private double[][] newSquared2dArray(int n) {
                double[][] resultMatrix = new double[n][];
                for (int i = 0; i < n; ++i) {
                    resultMatrix[i] = new double[n];
                }
                return resultMatrix;
            }

            int getRowNum() {
                return this.matrix2dArray.length;
            }

            double sumValues() {
                double totalSum = 0.0;
                for (int x = 0; x < this.getRowNum(); ++x) {
                    for (int y = 0; y < this.getRowNum(); ++y) {
                        totalSum += this.getValue(x, y);
                    }
                }
                return totalSum;
            }

            private boolean oddColumnCheck(double[][] matrix2dArray) {
                return matrix2dArray.length % 2 == 1;
            }

            private boolean oddRowCheck(double[][] matrix2dArray) {
                for (int i = 0; i < matrix2dArray.length; ++i) {
                    if (matrix2dArray[i].length % 2 != 0) continue;
                    return false;
                }
                return true;
            }

            private void throwNotOddNumberIllegalArgumentException() {
                throw new IllegalArgumentException("A matriz deve ser quadrada e ter um n\u00famero \u00edmpar de linhas e colunas");
            }

            private void setValue(int x, int y, double value) {
                this.matrix2dArray[x][y] = value;
            }

            double getValue(int x, int y) {
                return this.matrix2dArray[x][y];
            }

            Matrix multiply(Matrix otherMatrix) {
                if (this.getRowNum() != otherMatrix.getRowNum()) {
                    throw new IllegalArgumentException("Matrizes precisam ser do mesmo temanho para a multiplica\u00e7\u00e3o componente a componente");
                }
                Matrix resultMatrix = new Matrix(this.getRowNum());
                for (int x = 0; x < this.getRowNum(); ++x) {
                    for (int y = 0; y < this.getRowNum(); ++y) {
                        double result = this.getValue(x, y) * otherMatrix.getValue(x, y);
                        resultMatrix.setValue(x, y, result);
                    }
                }
                return resultMatrix;
            }
        }
    }
}

