/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.imageviewer.effects;

import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.effects.AbstractEffect;
import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tecgraf.javautils.gui.GUIUtils;

public final class LightEffect
extends AbstractEffect {
    final JSlider offsetSlider = new JSlider(0);
    final JSlider gammaSlider = new JSlider(0);
    final JSlider contrastSlider = new JSlider(0);
    private final int DEFAULT_GAMMA = 100;
    private final int DEFAULT_OFFSET = 0;
    private final int DEFAULT_CONTRAST = 100;

    public LightEffect(ImageViewer application) {
        super(application);
        this.offsetSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LightEffect.this.updatePreview();
            }
        });
        this.gammaSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LightEffect.this.updatePreview();
            }
        });
        this.contrastSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LightEffect.this.updatePreview();
            }
        });
        int oMin = -200;
        int oMax = 200;
        int oStep = 50;
        this.offsetSlider.setMinimum(-200);
        this.offsetSlider.setMaximum(200);
        this.offsetSlider.setValue(0);
        this.offsetSlider.setMajorTickSpacing(50);
        this.offsetSlider.setPaintTicks(true);
        this.offsetSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> offsetTable = new Hashtable<Integer, JLabel>();
        JLabel oMinLabel = new JLabel("-200%");
        offsetTable.put(new Integer(-200), oMinLabel);
        JLabel oMaxLabel = new JLabel("200%");
        offsetTable.put(new Integer(200), oMaxLabel);
        JLabel oDefLabel = new JLabel("0%");
        offsetTable.put(new Integer(0), oDefLabel);
        this.offsetSlider.setLabelTable(offsetTable);
        boolean cMin = false;
        int cMax = 500;
        this.contrastSlider.setMinimum(0);
        this.contrastSlider.setMaximum(500);
        this.contrastSlider.setValue(100);
        this.contrastSlider.setMajorTickSpacing(100);
        this.contrastSlider.setPaintTicks(true);
        this.contrastSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> contrastTable = new Hashtable<Integer, JLabel>();
        JLabel cMinLabel = new JLabel("0%");
        contrastTable.put(new Integer(0), cMinLabel);
        JLabel cMaxLabel = new JLabel("500%");
        contrastTable.put(new Integer(500), cMaxLabel);
        JLabel cDefLabel = new JLabel("100%");
        contrastTable.put(new Integer(100), cDefLabel);
        this.contrastSlider.setLabelTable(contrastTable);
        boolean gMin = false;
        int gMax = 300;
        this.gammaSlider.setMinimum(0);
        this.gammaSlider.setMaximum(300);
        this.gammaSlider.setValue(100);
        this.gammaSlider.setMajorTickSpacing(50);
        this.gammaSlider.setPaintTicks(true);
        this.gammaSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> gammaTable = new Hashtable<Integer, JLabel>();
        JLabel gMinLabel = new JLabel("0%");
        gammaTable.put(new Integer(0), gMinLabel);
        JLabel gMaxLabel = new JLabel("300%");
        gammaTable.put(new Integer(300), gMaxLabel);
        JLabel gDefLabel = new JLabel("100%");
        gammaTable.put(new Integer(100), gDefLabel);
        this.gammaSlider.setLabelTable(gammaTable);
    }

    @Override
    public JPanel getParameterPanel() {
        JLabel offsetLabel = new JLabel(this.getString("LightEffect.offset.label"));
        JLabel contrastLabel = new JLabel(this.getString("LightEffect.contrast.label"));
        JLabel gammaLabel = new JLabel(this.getString("LightEffect.gamma.label"));
        JComponent[] oRow = new JComponent[]{offsetLabel, this.offsetSlider};
        JComponent[] cRow = new JComponent[]{contrastLabel, this.contrastSlider};
        JComponent[] gRow = new JComponent[]{gammaLabel, this.gammaSlider};
        JComponent[][] rows = new JComponent[][]{oRow, cRow, gRow};
        return GUIUtils.createBasicGridPanel((JComponent[][])rows);
    }

    @Override
    public BufferedImage transformImage(BufferedImage image) {
        float offset = this.offsetSlider.getValue();
        float contrast = (float)this.contrastSlider.getValue() / 100.0f;
        float gamma = (float)this.gammaSlider.getValue() / 100.0f;
        short[] lookup = new short[256];
        for (int i = 0; i < 256; ++i) {
            double d = (double)contrast * Math.pow((float)i + offset, gamma);
            int v = (int)Math.round(d);
            if (v < 0) {
                v = 0;
            }
            if (v > 255) {
                v = 255;
            }
            lookup[i] = v;
        }
        ShortLookupTable lookupTable = new ShortLookupTable(0, lookup);
        LookupOp lightOp = new LookupOp(lookupTable, null);
        BufferedImage newImage = lightOp.filter(image, null);
        return newImage;
    }

    @Override
    public void resetParameters() {
        this.offsetSlider.setValue(0);
        this.contrastSlider.setValue(100);
        this.gammaSlider.setValue(100);
    }
}

