/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui.log;

import csbase.client.util.event.EventListener;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.LogPanelReloader;
import csbase.client.util.gui.log.actions.AutoReloadAction;
import csbase.client.util.gui.log.actions.CloseLogAction;
import csbase.client.util.gui.log.actions.DecPageAction;
import csbase.client.util.gui.log.actions.ExportLogAction;
import csbase.client.util.gui.log.actions.FirstPageAction;
import csbase.client.util.gui.log.actions.IncPageAction;
import csbase.client.util.gui.log.actions.LastPageAction;
import csbase.client.util.gui.log.actions.OpenLogAction;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public final class LogPanelToolBar
extends JToolBar {
    static final int OPEN_CLOSE = 1;
    static final int RELOAD = 2;
    static final int EXPORT = 3;
    static final int PAGING = 4;

    public LogPanelToolBar(LogPanel logPanel, int toolBarFlags) {
        this.setFloatable(false);
        this.initializeComponents(logPanel, toolBarFlags);
    }

    private void initializeComponents(LogPanel logPanel, int toolBarFlags) {
        if (this.has(toolBarFlags, 1)) {
            this.createOpenCloseButtons(logPanel);
            this.addSeparator();
        }
        if (this.has(toolBarFlags, 2)) {
            this.createReloadButton(logPanel);
            this.addSeparator();
        }
        if (this.has(toolBarFlags, 3)) {
            this.createExportLogButton(logPanel);
            this.addSeparator();
        }
        if (this.has(toolBarFlags, 4)) {
            this.createPagingButtons(logPanel);
        }
    }

    private void createOpenCloseButtons(LogPanel logPanel) {
        this.add(new OpenLogAction(logPanel));
        this.add(new CloseLogAction(logPanel));
    }

    private void createReloadButton(LogPanel logPanel) {
        final JToggleButton autoReloadButton = new JToggleButton();
        autoReloadButton.setAction(new AutoReloadAction(logPanel));
        autoReloadButton.setText(null);
        logPanel.getReloader().addStatusChangedEventListener(new EventListener<LogPanelReloader.StatusChangedEvent>(){

            @Override
            public void eventFired(LogPanelReloader.StatusChangedEvent event) {
                autoReloadButton.setSelected(event.isRunning());
            }
        });
        this.add(autoReloadButton);
    }

    private void createExportLogButton(LogPanel logPanel) {
        JButton exportLogButton = new JButton();
        exportLogButton.setAction(new ExportLogAction(logPanel));
        exportLogButton.setEnabled(false);
        exportLogButton.setText(null);
        this.add(exportLogButton);
    }

    private void createPagingButtons(LogPanel logPanel) {
        this.add(new FirstPageAction(logPanel));
        this.add(new DecPageAction(logPanel));
        final JTextField pageNumberText = new JTextField(10);
        pageNumberText.setEditable(false);
        pageNumberText.setHorizontalAlignment(0);
        pageNumberText.setMaximumSize(new Dimension(150, 30));
        long page = logPanel.getPageNumber();
        long pagesCount = logPanel.countPages();
        this.setText(pageNumberText, page, pagesCount);
        logPanel.addPagingEventListener(new EventListener<LogPanel.PagingEvent>(){

            @Override
            public void eventFired(LogPanel.PagingEvent event) {
                long page = event.getPageNumber();
                long pagesCount = event.countPages();
                LogPanelToolBar.this.setText(pageNumberText, page, pagesCount);
            }
        });
        this.add(pageNumberText);
        this.add(new IncPageAction(logPanel));
        this.add(new LastPageAction(logPanel));
    }

    private void setText(JTextField pageNumberText, long page, long pagesCount) {
        if (0L == pagesCount) {
            pageNumberText.setText("");
        } else {
            String pageLabel = LogPanelToolBar.getString("paging.label", page, pagesCount);
            pageNumberText.setText(pageLabel);
        }
    }

    private boolean has(int flags, int flag) {
        return (flags & flag) > 0;
    }

    private static final String getString(String tag, Object ... args) {
        return LogPanel.getString("ToolBar." + tag, args);
    }
}

