package csbase.client.algorithms;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.parameters.ParameterRegistry;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.remote.ClientRemoteLocator;
import tecgraf.javautils.core.lng.LNG;

/**
 * Ao que descreve todos os parmetros disponveis no sistema.
 */
public class ParametersDescriptionAction extends
  AbstractSimpleApplicationAction<Application> {

  /**
   * Fbrica dos parmetros disponveis no sistema.
   */
  private Map<String, ParameterFactory> factories;

  /**
   * @param application
   */
  public ParametersDescriptionAction(Application application) {
    super(application);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    ApplicationFrame frame = getApplication().getApplicationFrame();

    loadParametersFactory();
    ParametersDescriptionDialog descriptionDialog =
      new ParametersDescriptionDialog(frame, Dialog.ModalityType.MODELESS,
        factories);

    descriptionDialog.setVisible(true);

  }

  /**
   * Carrega as fbricas dos parmetros.
   */
  private void loadParametersFactory() {
    RemoteTask<Map<String, ParameterFactory>> task =
      new RemoteTask<Map<String, ParameterFactory>>() {

        @Override
        protected void performTask() throws Exception {
          ParameterRegistry registry = ClientRemoteLocator.algorithmService
            .getParameterRegistry();
          Map<String, ParameterFactory> factories = registry
            .getParameterFactories();

          setResult(factories);
        }
      };

    ApplicationFrame frame = getApplication().getApplicationFrame();
    task.execute(frame, LNG.get("ParametersDescriptionAction.task.title"), LNG
      .get("ParametersDescriptionAction.task.description"), true, false);

    if (task.getStatus()) {
      factories = task.getResult();
    }
    else {
      factories = new HashMap<String, ParameterFactory>();
    }
  }
}
