/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.client.algorithms.parameters;

import java.awt.Window;

import csbase.logic.algorithms.parameters.TextListParameter;

/**
 * Viso para o {@link TextListParameter Parmetro do Tipo Lista de Textos}.
 * 
 * @author lmoreira
 */
public final class TextListParameterView extends ListParameterView<String> {

  /**
   * Cria uma viso em modo {@link ParameterView.Mode#CONFIGURATION}.
   * 
   * @param window NO EST SENDO UTILIZADO. Existe somente para manter
   *        compatibilidade com o WebSintesi.
   * @param parameter O parmetro (No aceita {@code null}).
   * 
   * @deprecated para manter compatibilidade com o WebSintesi
   */
  @Deprecated
  public TextListParameterView(Window window, TextListParameter parameter) {
    this(parameter, Mode.CONFIGURATION);
  }

  /**
   * Cria a viso.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param mode Modo de visualizao. No aceita {@code null}, os possveis
   *        valores so: {@link ParameterView.Mode#CONFIGURATION} ou
   *        {@link ParameterView.Mode#REPORT}.
   */
  public TextListParameterView(TextListParameter parameter, Mode mode) {
    super(parameter, mode, new Parser<String>() {
      @Override
      public String parse(String text) {
        String trimmedText = text.trim();
        if (trimmedText.length() == 0) {
          return null;
        }
        return text;
      }
    }, new Formatter<String>() {
      @Override
      public String format(String element) {
        return element;
      }
    });
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TextListParameter getParameter() {
    return (TextListParameter) super.getParameter();
  }
}
