package csbase.client.preferences.editors;

import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;

/**
 * Classe que encapsula a edio de um valor inteiro.
 * 
 * @author Tecgraf
 */
public class PVIntegerEditor extends PreferenceEditor<Integer> {

  /**
   * Construtor padro.
   * 
   * @param pv objeto que encapsula o valor da preferncia.
   */
  public PVIntegerEditor(PreferenceValue<Integer> pv) {
    super(pv);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected JComponent createComponent() {
    int initialVaue = getValue();

    final SpinnerNumberModel model =
      new SpinnerNumberModel(initialVaue, Integer.MIN_VALUE, Integer.MAX_VALUE,
        1);

    model.addChangeListener(new ChangeListener() {
      @Override
      public void stateChanged(ChangeEvent e) {
        setValue((Integer) model.getValue());
        notifyListeners();
      }
    });

    JSpinner spinner = new JSpinner(model);
    spinner.setEnabled(isEditable());

    return spinner;
  }
}
