package csbase.client.algorithms.commands.view;

import java.util.Set;

import csbase.logic.ClientProjectFile;

/**
 * Representa a configurao de uma aba de log.
 * 
 * @author Tecgraf
 */
public class LogTabConfiguration {

  /**
   * Identificador da aba.
   */
  protected String id;

  /**
   * Ttulo da aba.
   */
  protected String title;

  /**
   * Conjunto de arquivos de log que devem aparecer na aba.
   */
  protected Set<ClientProjectFile> files;

  /**
   * Construtor.
   * 
   * @param id O identificador da aba.
   * @param title O ttulo da aba.
   * @param files O conjunto de arquivos de log que devem aparecer na aba.
   */
  public LogTabConfiguration(String id, String title,
    Set<ClientProjectFile> files) {
    this.id = id;
    this.title = title;
    this.files = files;
  }

  /**
   * Retorna o ttulo da aba.
   * 
   * @return title O ttulo.
   */
  public String getTitle() {
    return title;
  }

  /**
   * Retorna o identificador da aba.
   * 
   * @return id O identificador.
   */
  public String getId() {
    return id;
  }

  /**
   * Retorna o conjunto de arquivos de log que devem aparecer na aba.
   * 
   * @return files O conjunto de arquivos de log.
   */
  public Set<ClientProjectFile> getFiles() {
    return files;
  }

}
