package csbase.client.algorithms.parameters;

import csbase.logic.algorithms.parameters.BooleanColumn;
import csbase.logic.algorithms.parameters.DoubleColumn;
import csbase.logic.algorithms.parameters.EnumerationColumn;
import csbase.logic.algorithms.parameters.IntegerColumn;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parameters.TextColumn;

/**
 * Fbrica de {@link TableColumnView} usando reflexo.
 *
 * @author Tecgraf/PUC-Rio
 */
public class DefaultTableColumnViewFactory implements TableColumnViewFactory {
  /**
   * {@inheritDoc}
   */
  @Override
  public TableColumnView<?, ? extends TableColumn<?>> create(
    TableParameterView tableView, TableColumn<?> column) {
    if (column instanceof BooleanColumn) {
      return new BooleanColumnView(tableView, (BooleanColumn) column);
    }
    if (column instanceof DoubleColumn) {
      return new DoubleColumnView(tableView, (DoubleColumn) column);
    }
    if (column instanceof EnumerationColumn) {
      return new EnumerationColumnView(tableView, (EnumerationColumn) column);
    }
    if (column instanceof IntegerColumn) {
      return new IntegerColumnView(tableView, (IntegerColumn) column);
    }
    if (column instanceof TextColumn) {
      return new TextColumnView(tableView, (TextColumn) column);
    }
    return null;
  }
}
