/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.client.algorithms.parameters;

import csbase.exception.ParseException;

/**
 * Campo de Texto para representar Nmeros Inteiros.
 *
 * @author lmoreira
 */
public class IntegerTextField extends NumberTextField<Integer> {
  /**
   * Cria o campo.
   *
   * @param errorValue o valor usado para indicar erro.
   */
  public IntegerTextField(Integer errorValue) {
    this(new DefaultIntegerTextFieldModel(errorValue));
  }

  /**
   * Cria o campo.
   *
   * @param model O modelo (No aceita {@code null}).
   */
  public IntegerTextField(NumberTextFieldModel<Integer> model) {
    super(model);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected String format(Integer number) {
    return number.toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Integer parse(String text) throws ParseException {
    try {
      return Integer.parseInt(text);
    }
    catch (NumberFormatException e) {
      throw new ParseException(
        "O texto informado no representa um nmero inteiro.\n"
          + "Texto: ({0}).", text);
    }
  }
}
