/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree;

import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.versiontree.ExecutableFileNode.ExecutableDTO;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ImportExecutableFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.PasteFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.RemovePlatform;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.client.applications.algorithmsmanager.versiontree.datatransfer.ITransferableTarget;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ExecutablePathFactory;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         N que representa uma plataforma.
 */
final class PlatformNode extends AbstractVersionTreeNode implements
  ITransferableTarget {

  private final AlgorithmVersionInfo version;

  /**
   * Construtor.
   * 
   * @param tree rvore que detm este n.
   * @param version Informaes da verso que detm a plataforma representada.
   * @param platform Nome da plataforma representada por este n.
   */
  public PlatformNode(VersionTree tree, AlgorithmVersionInfo version,
    String platform) {
    super(tree, platform);

    this.version = version;

    List<FileInfo> files = version.getPlatforms().get(platform);
    for (FileInfo file : files) {
      add(new ExecutableFileNode(tree, version, platform, file));
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getImageIcon() {
    return ApplicationImages.ICON_FOLDER_16;
  }

  /**
   * Cria um menu pop-up para este n.
   * 
   * @return um menu pop-up para este n.
   */
  @Override
  public JPopupMenu createPopupMenu() {
    JPopupMenu popupMenu = new JPopupMenu();
    popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
      new ImportExecutableFile(getTree(), version, getPlatformName()))));
    popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
      new PasteFile(getTree(), LNG.get("algomanager.menu.bin_file.paste"),
        ExecutableFileNode.DATA_FLAVOR))));
    popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
      new RemovePlatform(getTree(), version, getPlatformName()))));

    return popupMenu;
  }

  /**
   * Obtm o nome do n plataforma
   *
   * @return nome do n plataforma
   */
  private String getPlatformName() {
    return getUserObject().toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canImport(Object[] data, DataFlavor flavor) {
    return null != data && 0 < data.length
      && ExecutableFileNode.DATA_FLAVOR.equals(flavor);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean importData(Object[] data) {
    ExecutableDTO dto = (ExecutableDTO) data[0];
    final AlgorithmVersionInfo sourceVersion = dto.getVersion();
    final String sourcePlatform = dto.getPlatformName();
    List<FileInfo> files = new ArrayList<>(data.length);
    for (Object obj : data) {
      dto = (ExecutableDTO) obj;
      FileInfo file = dto.getFile();
      files.add(file);
    }

    IPathFactory sourcePathFactory =
      new ExecutablePathFactory(sourceVersion, sourcePlatform);
    IPathFactory targetPathFactory =
      new ExecutablePathFactory(version, getPlatformName());
    AlgorithmManagementProxy.copyFiles(sourceVersion, files, sourcePathFactory,
      version, null, targetPathFactory, true, getWindow());

    return true;
  }
}
