/**
 * $Id$
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.ClientUtilities;
import csbase.logic.ClientAlgorithmFile;
import csbase.logic.ClientAlgorithmFile.AlgorithmFileType;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

/**
 * Ao para renomera um arquivo a rvore de verses de algoritmos.
 *
 * @author Tecgraf/PUC-Rio
 */
public class CommonAlgoFileRenameAction extends AbstractVersionTreeNodeAction {

  /**
   * Construtor.
   *
   * @param tree rvore que detm o n fonte da ao.
   */
  public CommonAlgoFileRenameAction(VersionTree tree) {
    super(tree, LNG.get("algomanager.menu.doc.rename"));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    startRenamingAction();
  }

  /**
   * Renomeia um arquivo do algoritmo.
   *
   * @param version Verso de origem do arquivo a ser alterado.
   * @param algoFileType tipo do arquivo na rvore de algoritmos
   * @param fileInfo Informaes de um arquivo da rea de algoritmos
   * @param name Novo nome.
   * @return true caso consiga renomear, false caso contrrio.
   */
  public boolean renameFile(AlgorithmVersionInfo version,
    AlgorithmFileType algoFileType, FileInfo fileInfo, String name) {
    ClientAlgorithmFile file = new ClientAlgorithmFile(version.getInfo(),
      version.getId(), fileInfo.getName(), fileInfo.getPathAsArray(),
      algoFileType, false);
    return rename(file, name);
  }

  /**
   * Renomeia um arquivo executvel do algoritmo.
   *
   * @param version Verso de origem do arquivo a ser alterado.
   * @param platformName Nome da plataforma do arquivo.
   * @param fileInfo Informaes de um arquivo da rea de algoritmos
   * @param name Novo nome.
   * @return true caso consiga renomear, false caso contrrio.
   */
  public boolean renameExecFile(AlgorithmVersionInfo version,
    String platformName, FileInfo fileInfo, String name) {
    ClientAlgorithmFile file = new ClientAlgorithmFile(version.getInfo(),
      version.getId(), platformName, fileInfo.getName(), fileInfo
        .getPathAsArray(), false);
    return rename(file, name);
  }

  /**
   * Renomeia o arquivo
   * 
   * @param file o arquivo a ser nomeado
   * @param name o novo nome do arquivo
   *
   * @return true se conseguiu renomear o arquivo, false caso contrario.
   */
  private boolean rename(ClientAlgorithmFile file, String name) {
    final Window owner = getWindow();
    final String nameTrimmed = name.trim();
    if (!ClientUtilities.isValidFileName(nameTrimmed)) {
      StandardDialogs.showErrorDialog(owner, LNG.get("GENERIC.title.error"), LNG
        .get("algomanager.error.invalid_filename"));
      return false;
    }
    /* Define os textos de mensagens */
    final String fileType = file.isDirectory() ? LNG.get(
      "algomanager.filetype.directory") : LNG.get("algomanager.filetype.file");

    /* Define e cria a RemoteTask */
    RemoteTask<Void> task = new RemoteTask<Void>() {

      @Override
      protected void performTask() throws Exception {
        file.rename(nameTrimmed);
      }
    };

    /*
     * Executa a tarefa. Os erros so tratados diretamente por ela.
     */
    return task.execute(owner, "Renomear", MessageFormat.format(LNG.get(
      "algomanager.msg.rename_wait"), new Object[] { fileType }));
  }

  /**
   * Inicia a edio de um nome de um arquivo ou diretrio da rvore.
   */
  private void startRenamingAction() {
    getTree().startEditingAtPath(getTree().getSelectionPath());
  }
}
