/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree.actions;

import java.rmi.RemoteException;

import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         Ao que exporta um arquivo de documentao.
 */
public class ExportDocumentationFile extends AbstractExportFileAction {

  /** Verso de origem do arquivo a ser exportado. **/
  private AlgorithmVersionInfo version;

  /**
   * Construtor.
   * 
   * @param tree rvore que detm o n fonte da ao.
   * @param version Verso de origem do arquivo a ser exportado.
   * @param file Arquivo de documentao a ser exportado.
   */
  public ExportDocumentationFile(VersionTree tree,
    AlgorithmVersionInfo version, FileInfo file) {
    super(tree, LNG.get("algomanager.menu.doc.export"), file);

    this.version = version;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected RemoteFileChannelInfo prepareDownload(FileInfo source)
    throws RemoteException {
    return ClientRemoteLocator.algorithmService.prepareDownloadDocFile(version
      .getInfo().getId(), version.getId(), getSourcePath(source));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void appletExport(FileInfo source) {
    String filePath =
      FileUtils.joinPath('/', version.getVersionsDirName(),
        version.getDirectory(), version.getDocumentationDirName(),
        source.getPath());
    String dialogTitle = LNG.get("algomanager.title.doc.management");
    export(version.getInfo().getId(), filePath, dialogTitle);
  }
}
