/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree.actions;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;

import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         Ao para remover arquivos de configurao.
 */
public class RemoveConfigurationFiles extends AbstractVersionTreeNodeAction {

  // Verso que detm os arquivos.
  private final AlgorithmVersionInfo version;
  // Arquivos a serem removidos.
  private final FileInfo[] files;

  /**
   * Construtor.
   * 
   * @param tree rvore que detm o n fonte da ao.
   * @param version Verso que detm os arquivos.
   * @param files Arquivos a serem removidos.
   */
  public RemoveConfigurationFiles(VersionTree tree,
    AlgorithmVersionInfo version, FileInfo[] files) {
    super(tree, LNG.get("algomanager.menu.config.remove"));

    this.version = version;
    this.files = files;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    new RemoveConfiguratorDialog().show();
  }

  /**
   * Classe que representa um dilogo de remoo de configuradores.
   * 
   * @author Leonardo Barros
   */
  private class RemoveConfiguratorDialog {

    /**
     * Exibe o dilogo.
     */
    public void show() {
      // #TODO Checar qual deve ser o ttulo
      String dialogTitle = LNG.get("algomanager.title.config.management");
      Object[] options =
        { LNG.get("algomanager.button.remove"),
            LNG.get("algomanager.button.cancel") };
      int opt =
        StandardDialogs.showOptionDialog(getWindow(), dialogTitle,
          MessageFormat.format(
            LNG.get("algomanager.msg.confirm.configurator_remove"),
            new Object[] { FormatUtils.format(files) }), options);
      if (opt != 0) {
        return;
      }
      boolean success =
        AlgorithmManagementProxy.removeConfigurationFiles(version, files,
          getWindow());
      if (!success) {
        StandardErrorDialogs.showErrorDialog(getWindow(),
          LNG.get("algomanager.title.error") + " - " + dialogTitle,
          LNG.get("algomanager.error.configurator_remove"));
      }
    }
  }
}
