/*
 * $Id: EventPanel.java 112434 2010-11-10 18:06:20Z clinio $
 */
package csbase.client.applications.desktoplauncher.panels.eventpanel;

import java.awt.BorderLayout;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

import tecgraf.javautils.gui.table.SortableTable;
import csbase.client.applications.ApplicationComponentPanel;
import csbase.client.applications.desktoplauncher.DesktopLauncher;
import csbase.client.applications.desktoplauncher.DesktopLauncherEvent;

/**
 * @author Tecgraf/PUC-Rio
 */
public class EventPanel extends ApplicationComponentPanel<DesktopLauncher> {

  /**
   * Tabela de arquivos locais.
   */
  private SortableTable table = new SortableTable();

  /**
   * Montagem do painel
   */
  private void mountPanel() {
    final String timeText = getString("time.column");
    final String dirText = getString("direction.column");
    final String treatText = getString("treated.column");
    final String otherText = getString("other.id.column");
    final String typeText = getString("type.column");
    final String classText = getString("class.column");
    final String valueText = getString("value.column");
    final String[] cNames =  new String[] { timeText, dirText,  treatText, otherText, typeText, classText, valueText };
    final EventModel model = new EventModel(cNames);
    table.setModel(model);
    table.setNoSortStateEnabled(true);

    table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    table.sort(0, SortOrder.DESCENDING);

    final EventRenderer renderer = new EventRenderer();
    table.setDefaultRenderer(Object.class, renderer);

    final TableColumnModel colModel = table.getColumnModel();
    table.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
    final TableColumn c0 = colModel.getColumn(0);
    final TableColumn c1 = colModel.getColumn(1);
    final TableColumn c2 = colModel.getColumn(2);
    final TableColumn c3 = colModel.getColumn(3);
    final TableColumn c4 = colModel.getColumn(4);
    final TableColumn c5 = colModel.getColumn(5);
    c0.setMinWidth(40);
    c1.setMinWidth(20);
    c2.setMinWidth(20);
    c3.setMinWidth(100);
    c4.setMinWidth(70);
    c5.setMinWidth(70);

    setLayout(new BorderLayout());
    final JScrollPane scrollPane = new JScrollPane(table);
    add(scrollPane, BorderLayout.CENTER);
  }

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public EventPanel(final DesktopLauncher application) {
    super(application);
    mountPanel();
  }

  /**
   * {@link EventModel#addLauncherEvent(DesktopLauncherEvent)}
   * 
   * @param ev evento
   */
  public void addLauncherEvent(DesktopLauncherEvent ev) {
    final EventModel model = (EventModel) table.getModel();
    model.addLauncherEvent(ev);
  }

  /**
   * {@link EventModel#clearLauncherEvents()} }
   */
  public void clearLauncherEvents() {
    final EventModel model = (EventModel) table.getModel();
    model.clearLauncherEvents();
  }

}
