/*
 * $Id: FileTransferClientFrame.java 88951 2009-03-05 21:26:35Z clinio $
 */

package csbase.client.applications.filetransferclient.dialogs.core;

import java.awt.BorderLayout;
import java.awt.Container;

import javax.swing.JPanel;

import csbase.client.applications.ApplicationComponentFrame;
import csbase.client.applications.filetransferclient.FileTransferClient;

/**
 * Classe que representa um tipo de frame da aplicao
 * {@link FileTransferClient}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FileTransferClientFrame extends ApplicationComponentFrame {

  /**
   * Indicativo de dilogo j montado
   */
  private boolean mounted = false;

  /**
   * Retorna um texto de internacionalizao.
   * 
   * @param tag a tag
   * @return o texto
   */
  final protected String getString(String tag) {
    final FileTransferClient ftpClient = getApplication();
    final Class<? extends FileTransferClientFrame> cls = this.getClass();
    final String prefix = cls.getSimpleName();
    return ftpClient.getString(prefix + "." + tag);
  }

  /**
   * Fim do dilogo.
   */
  final public void stop() {
    frameStopped();
    dispose();
  }

  /**
   * Exibio do dilogo.
   */
  final public void start() {
    if (!mounted) {
      mountFrame();
    }
    center();
    setVisible(true);
    frameStarted();
  }

  /**
   * Montagem do frame
   */
  private void mountFrame() {
    final FileTransferClient ftpClient = getApplication();
    final JPanel panel = buildPanel(ftpClient);
    final Container root = getContentPane();
    root.setLayout(new BorderLayout());
    root.add(panel, BorderLayout.CENTER);
    pack();
    mounted = true;
  }

  /**
   * Consulta a instncia da aplicaco.
   * 
   * @return a aplicaco
   */
  @Override
  final public FileTransferClient getApplication() {
    return (FileTransferClient) super.getApplication();
  }

  /**
   * 
   */
  protected void frameStopped() {
  }

  /**
   * 
   */
  protected void frameStarted() {
  }

  /**
   * Montagem do painel.
   * 
   * @param fileTransferClient o programa
   * @return o painel
   */
  protected JPanel buildPanel(FileTransferClient fileTransferClient) {
    return new JPanel();
  }

  /**
   * Construtor
   * 
   * @param fileTransferClient a aplicao.
   */
  public FileTransferClientFrame(final FileTransferClient fileTransferClient) {
    super(fileTransferClient.getName(), fileTransferClient);
    setTitle(getString("title"));
  }

}
