package csbase.client.applications.flowapplication.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

import csbase.client.ClientLocalFile;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;

/**
 * Ao carregar grafo local. Ao que facilita utilizar o mtodo
 * {@link FlowApplication#openGraph(csbase.logic.ClientFile) }.
 */
public final class LoadLocalAction extends FlowApplicationAction {
  /**
   * Cria uma ao.
   *
   * @param application A aplicao.
   */
  public LoadLocalAction(FlowApplication application) {
    super(application, ApplicationImages.ICON_OPEN_LOCAL_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleActionPerformed(ActionEvent e) {
    final FlowApplication app = getApplication();
    final String defType = app.getDefaultFileType();
    final ApplicationFrame window = app.getApplicationFrame();
    final List<String> fileTypes = new ArrayList<>();
    fileTypes.add(defType);
    ClientLocalFile file = ClientLocalFileChooserUtil
      .browseSingleFileInOpenMode(window, fileTypes, app.getName(), true,
        (ClientLocalFile) null);
    app.openGraph(file);
  }
}
