package csbase.client.applications.jobmonitor;

import javax.swing.Icon;

/**
 * Classe que armazena as informaes do sistema CSBASE em execuo. Essas
 * informaes so definidas no arquivo de propriedades da aplicao no
 * repositrio de aplicaes.
 * 
 * @author Tecgraf
 */
public class JobMonitorSystemInfo {

  /** Icone que define o sistema. */
  private Icon systemIcon;

  /** String que define o nome do sistema. */
  private String systemName;

  /**
   * Construtor padro.
   * 
   * @param systemIcon - icone que define o sistema
   * @param systemName - string que define o nome do sistema
   */
  public JobMonitorSystemInfo(Icon systemIcon, String systemName) {
    super();
    this.systemIcon = systemIcon;
    this.systemName = systemName;
  }

  /**
   * Icone que define o sistema.
   * 
   * @return icone que define o sistema.
   */
  public Icon getSystemIcon() {
    return systemIcon;
  }

  /**
   * String que define o nome do sistema.
   * 
   * @return string que define o nome do sistema.
   */
  public String getSystemName() {
    return systemName;
  }

}
