package csbase.client.applications.preferenceviewer.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import csbase.client.preferences.PreferenceCategory;

/**
 * Modelo da rvore de preferncias.
 * 
 * @author Tecgraf
 */
public class PreferenceTreeModel implements TreeModel {

  /** N raiz. */
  private PreferenceCategory root;

  /** Lista com a ordem de exibio das categorias. */
  private List<String> order;

  /** Lista com os ouvintes do modelo. */
  private List<TreeModelListener> listeners;

  /**
   * Construtor padro.
   * 
   * @param root - raiz da rvore.
   */
  public PreferenceTreeModel(PreferenceCategory root) {
    this.root = root;
    this.listeners = new ArrayList<TreeModelListener>();
  }

  /**
   * Define a ordem das categorias.
   * 
   * @param order - ordem das categorias.
   */
  public void setOrder(List<String> order) {
    this.order = order;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void addTreeModelListener(TreeModelListener l) {
    listeners.add(l);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getChild(Object parent, int index) {
    PreferenceCategory pc = (PreferenceCategory) parent;
    return getChildren(pc).get(index);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getChildCount(Object parent) {
    PreferenceCategory pc = (PreferenceCategory) parent;
    return pc.getCategories().size();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getIndexOfChild(Object parent, Object child) {
    PreferenceCategory parentPc = (PreferenceCategory) parent;
    PreferenceCategory childPc = (PreferenceCategory) child;

    List<PreferenceCategory> children = getChildren(parentPc);
    return children.indexOf(childPc);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getRoot() {
    return root;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isLeaf(Object node) {
    PreferenceCategory pc = (PreferenceCategory) node;
    return pc.getCategories().isEmpty();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void removeTreeModelListener(TreeModelListener l) {
    listeners.remove(l);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void valueForPathChanged(TreePath path, Object newValue) {
  }

  /**
   * Ordena as categorias filhas de acordo com o critrio: <br/>
   * - Ordem alfabtica do rtulo. <br/>
   * - Ordem da lista configurvel pelo sistema.
   * 
   * @param pc - categoria root.
   * 
   * @return lista das categorias ordenada.
   */
  private List<PreferenceCategory> getChildren(PreferenceCategory pc) {
    List<PreferenceCategory> children = pc.getCategories();
    Collections.sort(children, new Comparator<PreferenceCategory>() {
      @Override
      public int compare(PreferenceCategory c1, PreferenceCategory c2) {
        return c1.getLabel().compareTo(c2.getLabel());
      }
    });

    int added = 0;
    if (order != null) {
      for (int i = 0; i < order.size(); i++) {
        String elem = order.get(i);

        for (int j = 0; j < children.size(); j++) {
          if (children.get(j).getId().endsWith(elem)) {
            PreferenceCategory child = children.remove(j);
            children.add(added++, child);
          }
        }
      }
    }

    return children;
  }

}