/*
 * $Id:$
 */

package csbase.client.applications.projectsmanager.actions.core;

import java.awt.event.ActionEvent;
import java.util.List;

import javax.swing.Action;
import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationAction;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;

/**
 * Ao genrica do programa ProjectsManager
 * 
 * @author Tecgraf/PUC-Rio
 */
abstract public class ProjectsManagerAction extends
  ApplicationAction<ProjectsManager> {

  /**
   * Tag usado para buscar o nome da ao.
   */
  final static protected String TAG_NAME = "name";

  /**
   * Tag usado para buscar o mnemnico da ao.
   */
  final static protected String TAG_MNEMONIC = "mnemonic";

  /**
   * Tag usado para buscar o tooltip da ao.
   */
  final static protected String TAG_TOOLTIP = "tooltip";

  /**
   * Consulta a aplicao
   * 
   * @return aplicao.
   */
  final public ProjectsManager getProjectsManager() {
    return getApplication();
  }

  /**
   * Consulta se a ao possui uma imagem standard; se houver a imagem usada
   * aqui ser usada, seno valer a definida pelo mtodo
   * <code>getImageIcon()</code>.
   * 
   * @return uma imagem standard (ou null)
   */
  public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Ajuste de proprieades default.
   */
  private void loadDefaultValues() {
    final String name = getName();
    if (name != null) {
      putValue(Action.NAME, name);
    }

    final Integer mnemonic = getMnemonic();
    if (mnemonic != null) {
      putValue(Action.MNEMONIC_KEY, mnemonic);
    }

    final ImageIcon icon = getImageIcon();
    if (icon != null) {
      putValue(Action.SMALL_ICON, icon);
    }

    final String tooltip = getToolTipText();
    if (tooltip != null) {
      putValue(Action.SHORT_DESCRIPTION, tooltip);
    }
  }

  /**
   * Mtodo de busca de uma string de internacionalizao dentro do escopo da
   * ao conforme o padro "<code>NomeDaClasse.TagDesejada</code>"
   * 
   * @param tag tag desejada
   * @return o texto de internacionalizao
   */
  public String getClassString(final String tag) {
    return ProjectsManagerUI.getClassString(this.getClass(), tag);
  }

  /**
   * Mtodo de busca de uma string de internacionalizao dentro do escopo da
   * ao.
   * 
   * @param tag tag desejada
   * @return o texto de internacionalizao
   */
  public String getString(final String tag) {
    return ProjectsManagerUI.getString(tag);
  }

  /**
   * Mtodo de busca de uma string de internacionalizao dentro do escopo da
   * ao conforme o padro "<code>NomeDaClasse.TagDesejada</code>"
   * 
   * @param tag tag desejada
   * @return o texto de internacionalizao
   */
  final public boolean hasString(final String tag) {
    return ProjectsManagerUI.hasClassString(this.getClass(), tag);
  }

  /**
   * Mtodo de consulta ao texto de <i>tooltip</i> da ao montado no padro "
   * <code>NomeDaClasse.NAME_SUFIX</code>"
   * 
   * @return o texto (nome) da ao.
   * @see #getClassString(String)
   */
  final public String getName() {
    if (!hasString(TAG_NAME)) {
      return null;
    }
    final String name = getClassString(TAG_NAME);
    if (ProjectsManagerUI.isEmptyString(name)) {
      return null;
    }
    return name;
  }

  /**
   * Mtodo de consulta ao texto de <i>tooltip</i> da ao montado no padro "
   * <code>NomeDaClasse.tooltip</code>"
   * 
   * @return o texto de tooltip
   * @see #getClassString(String)
   */
  final public String getToolTipText() {
    if (!hasString(TAG_TOOLTIP)) {
      return null;
    }
    final String tp = getClassString(TAG_TOOLTIP);
    if (ProjectsManagerUI.isEmptyString(tp)) {
      return null;
    }
    return tp;
  }

  /**
   * Consulta ao mnemnico da ao.
   * 
   * @return o mnemnico
   */
  final public Integer getMnemonic() {
    if (!hasString(TAG_MNEMONIC)) {
      return null;
    }
    final String mn = getClassString(TAG_MNEMONIC);
    if (ProjectsManagerUI.isEmptyString(mn)) {
      return null;
    }
    return Integer.valueOf(mn.charAt(0));
  }

  /**
   * Mtodo de definio da imagem associada a ao.
   * 
   * @return um objeto do tipo <code>ImageIcon</code>.
   */
  final private ImageIcon getImageIcon() {
    final ImageIcon stdIcon = getStandardImageIcon();
    if (stdIcon != null) {
      return stdIcon;
    }

    //final String IMG_ACTION_DIR = "actions";
    final String prefix = getClass().getSimpleName();
    final String name = prefix + ".16";
    //final String pth = IMG_ACTION_DIR + "/" + name;
    final String pth = name;

    final ProjectsManager projectsManager = getProjectsManager();
    final ImageIcon icon = projectsManager.buildApplicationImage(pth);
    if (icon == ApplicationImages.ICON_NONE) {
      return null;
    }
    return icon;
  }

  /**
   * Resultado da ao encapsulada do Java.
   * 
   * @param ae evento Java
   * @see #actionDone()
   */
  @Override
  final public void actionPerformed(final ActionEvent ae) {
    try {
      actionDone();
    }
    catch (Exception e) {
      final ProjectsManager projectsManager = getProjectsManager();
      ProjectsManagerUI.handleException(projectsManager, e);
    }
  }

  /**
   * @param projectsManager A aplicao
   */
  public ProjectsManagerAction(final ProjectsManager projectsManager) {
    super(projectsManager);
    loadDefaultValues();
  }

  /**
   * Realiza a validao dos projetos sobre os quais a action atua.
   * 
   * @param projectList Lista de projetos.
   * @return Uma lista com os projetos que foram removidos da lista, pois no
   *         podem sofrer a alterao efetuada pela ao.
   */
  protected List<ProjectsManagerData> validateProjects(
    List<ProjectsManagerData> projectList) {
    return null;
  }

  /**
   * Ao efeitiva a ser determinada pelas sub-classes
   * 
   * @throws Exception se houver falha na operao.
   */
  abstract public void actionDone() throws Exception;

}
