/*
 * $Id:$
 */

package csbase.client.desktop;

import java.text.MessageFormat;

import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.Client;

/**
 * Classe genrica de ao do desktop.
 * 
 * @author Tecgraf/PUC-Rio
 * 
 * @param <T> Classe do Desktop do sistema
 */
abstract public class DesktopAction<T extends DesktopFrame> extends
  AbstractAction {

  /**
   * Desktop
   */
  final private T desktop;

  /**
   * Consulta o dektop da ao.
   * 
   * @return o desktop
   */
  final protected T getDesktop() {
    return desktop;

  }

  /**
   * Retorna um texto de internacionalizao.
   * 
   * @param key o sufixo da chave. A chave ser: \"
   *        {@code getClass().getSimpleName()}.{@code key_sufix}\"
   * 
   * @return o texto internacionalizado.
   */
  protected final String getString(final String key) {
    final String className = getClass().getSimpleName();
    final String formattedKey = String.format("%s.%s", className, key);
    if (LNG.hasKey(formattedKey)) {
      return LNG.get(formattedKey);
    }
    return "<<" + formattedKey + ">>";
  }

  /**
   * Retorna um texto de internacionalizao.
   * 
   * @param key o sufixo da chave. A chave ser: \"
   *        {@code getClass().getSimpleName()}.{@code key_sufix}\"
   * 
   * @param args argumentos do texto. O texto ser formatado utilizando-se da
   *        classe {@link MessageFormat}.
   * 
   * @return o texto internacionalizado.
   */
  protected final String getString(final String key, final Object... args) {
    final String className = getClass().getSimpleName();
    final String formattedKey = String.format("%s.%s", className, key);
    if (LNG.hasKey(formattedKey)) {
      return LNG.get(formattedKey, args);
    }
    return "<<" + formattedKey + ">>";
  }

  /**
   * Mtodo para exibio de uma mensagem de alerta.
   * 
   * @param msg o texto da mensagem.
   */
  final protected void showErrorMessage(final String msg) {
    showMessage(msg, JOptionPane.ERROR_MESSAGE);
  }

  /**
   * Mtodo para exibio de uma mensagem informativa.
   * 
   * @param msg o texto da mensagem.
   */
  final protected void showInformation(final String msg) {
    showMessage(msg, JOptionPane.INFORMATION_MESSAGE);
  }

  /**
   * Mtodo para exibio de uma mensagem do tipo especificado.
   * 
   * @param msg informao a ser exibida.
   * @param type tipo da mensagem.
   */
  final private void showMessage(final Object msg, final int type) {
    final Client client = Client.getInstance();
    final String systemName = client.getSystemName();
    final JFrame frame = desktop.getDesktopFrame();
    JOptionPane.showMessageDialog(frame, msg, systemName, type);
  }

  /**
   * Mtodo para exibio de uma mensagem de alerta.
   * 
   * @param panel painel de informaes
   */
  final protected void showPanel(final JPanel panel) {
    showMessage(panel, JOptionPane.PLAIN_MESSAGE);
  }

  /**
   * Mtodo para exibio de uma mensagem de alerta.
   * 
   * @param msg o texto da mensagem.
   */
  final protected void showWarning(final String msg) {
    showMessage(msg, JOptionPane.WARNING_MESSAGE);
  }

  /**
   * Construtor
   * 
   * @param desktop desktop
   */
  public DesktopAction(final T desktop) {
    if (desktop == null) {
      final String err = "null desktop!";
      throw new IllegalArgumentException(err);
    }
    this.desktop = desktop;
  }
}
