package csbase.client.desktop.instancestoolbar;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import csbase.client.applicationmanager.ApplicationType;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import tecgraf.javautils.core.lng.LNG;

/**
 * Tarefas de mouse na toolbar.
 *
 * @author Tecgraf/PUC-Rio
 */
public class ApplicationInstancesToolbarMouseAdapter extends MouseAdapter {

  /**
   * Elemento
   */
  final private JComponent widget;

  /**
   * Instncias
   */
  final private Vector<ApplicationType> instances;

  /**
   * Obtem uma string de idioma.
   *
   * @param key a chave
   * @return o texto
   */
  private String getString(final String key) {
    final String className = this.getClass().getSimpleName();
    return LNG.get(className + "." + key);
  }

  /**
   * Exibio de menu de boto 1.
   */
  private void showMenuButton1() {
    final JPopupMenu popmenu = new JPopupMenu();
    for (final ApplicationType instance : instances) {
      final JMenu menu = new JMenu();
      menu.setText(getApplicationInstanceLabel(instance));
      addWindowItems(menu, instance);
      menu.addSeparator();
      addInstanceItems(menu, instance);
      popmenu.add(menu);
    }
    popmenu.setVisible(true);
    popmenu.setVisible(false);
    popmenu.show(widget, 0, -popmenu.getHeight());
  }

  /**
   * Consulta o label para uma instncia de applicao.
   *
   * @param instance instncia
   * @return texto.
   */
  private String getApplicationInstanceLabel(ApplicationType instance) {
    final String appName = instance.getName();
    final String appIdx = "[" + instance.getInstanceIndex() + "]";
    final String defaultName = appName + " - " + appIdx;
    if (!(instance instanceof Application)) {
      return defaultName;
    }
    final Application app = (Application) instance;
    final ApplicationFrame appFrame = app.getApplicationFrame();
    if (appFrame == null) {
      return defaultName;
    }

    final String title = appFrame.getTitle();
    if (title == null) {
      return defaultName;
    }

    final String text = title + " - " + appIdx;
    final int max = 40;
    if (text.length() <= max) {
      return text;
    }

    final String prefix = text.substring(0, max / 2);
    final String sufix = text.substring(max / 2);
    return prefix + "..." + sufix;
  }

  /**
   * Criao do menu de opo "ocultar"
   *
   * @param menu menu.
   * @param instance instncia
   */
  private void addWindowItems(JMenu menu, ApplicationType instance) {
    JFrame frm = null;
    if (instance instanceof Application) {
      final Application app = (Application) instance;
      frm = app.getApplicationFrame();
    }
    else if (instance instanceof csbase.client.csdk.v1_0.application
      .CSDKApplication) {
      final csbase.client.csdk.v1_0.application.CSDKApplication app =
        (csbase.client.csdk.v1_0.application.CSDKApplication) instance;
      final csdk.v1_0.api.application.IApplication iapp = app.getApplication();
      if (iapp instanceof csdk.v1_0.helper.AbstractCSDKWindowApplication) {
        csdk.v1_0.helper.AbstractCSDKWindowApplication csapp =
          (csdk.v1_0.helper.AbstractCSDKWindowApplication) iapp;
        frm = csapp.getApplicationFrame();
      }
    }
    else if (instance instanceof csbase.client.csdk.v2.application
      .CSDKApplication) {
      final csbase.client.csdk.v2.application.CSDKApplication app =
        (csbase.client.csdk.v2.application.CSDKApplication) instance;
      final csdk.v2.api.application.IApplication iapp = app.getApplication();
      if (iapp instanceof csdk.v2.helper.AbstractCSDKWindowApplication) {
        csdk.v2.helper.AbstractCSDKWindowApplication csapp =
          (csdk.v2.helper.AbstractCSDKWindowApplication) iapp;
        frm = csapp.getApplicationFrame();
      }
    }
    if (frm == null) {
      return;
    }

    final JFrame frame = frm;
    final JMenuItem hideItem = new JMenuItem(new AbstractAction() {
      @Override
      public void actionPerformed(ActionEvent ae) {
        frame.setState(Frame.ICONIFIED);
      }
    });
    hideItem.setText(getString("hide.menu"));

    final JMenuItem showItem = new JMenuItem(new AbstractAction() {
      @Override
      public void actionPerformed(ActionEvent ae) {
        frame.setState(Frame.NORMAL);
        frame.toFront();
      }
    });
    showItem.setText(getString("show.menu"));

    final JMenuItem frontItem = new JMenuItem(new AbstractAction() {
      @Override
      public void actionPerformed(ActionEvent ae) {
        frame.toFront();
      }
    });
    frontItem.setText(getString("front.menu"));

    if ((frame.getState() & Frame.ICONIFIED) != 0) {
      menu.add(showItem);
    }
    else {
      menu.add(frontItem);
      menu.add(hideItem);
    }
  }

  /**
   * Criao do menu de opo "ocultar"
   *
   * @param menu menu.
   * @param instance instncia
   */
  private void addInstanceItems(final JMenu menu,
    final ApplicationType instance) {
    final JMenuItem killItem = new JMenuItem(new AbstractAction() {
      @Override
      public void actionPerformed(ActionEvent ae) {
        instance.closeApplication();
      }
    });

    killItem.setIcon(ApplicationImages.ICON_EXIT_16);
    killItem.setText(getString("kill.menu"));
    menu.add(killItem);
  }

  /**
   * Exibio de menu de boto 3.
   */
  private void showMenuButton3() {
    final JPopupMenu menu = new JPopupMenu();
    final JMenuItem killAllItem = createKillAllItem();
    menu.add(killAllItem);
    menu.setVisible(true);
    menu.setVisible(false);
    menu.show(widget, 0, -menu.getHeight());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mouseEntered(MouseEvent e) {
    ApplicationInstancesToolbar.setWidgetBorder(widget, true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mouseExited(MouseEvent e) {
    ApplicationInstancesToolbar.setWidgetBorder(widget, false);
  }

  /**
   * Criao do menu de matar todas as instncias.
   *
   * @return o menu
   */
  private JMenuItem createKillAllItem() {
    final List<ApplicationType> toKill = new ArrayList<>(instances);
    final JMenuItem item = new JMenuItem(new AbstractAction() {
      @Override
      public void actionPerformed(ActionEvent ae) {
        toKill.forEach(ApplicationType::closeApplication);
      }
    });
    item.setText(getString("kill.all.item"));
    return item;
  }

  /**
   * Tratador de evento do mouse.
   *
   * @param e evento.
   */
  private void mouseTreated(MouseEvent e) {
    final int button = e.getButton();
    if (button == MouseEvent.BUTTON1) {
      showMenuButton1();
    }
    else if (button == MouseEvent.BUTTON3) {
      showMenuButton3();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mouseClicked(MouseEvent e) {
    // mouseTreated(e);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mousePressed(MouseEvent e) {
    mouseTreated(e);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void mouseReleased(MouseEvent e) {
    // mouseTreated(e);
  }

  /**
   * Construtor
   *
   * @param widget widget
   * @param instances instncias da aplicao.
   */
  protected ApplicationInstancesToolbarMouseAdapter(final JComponent widget,
    final Vector<ApplicationType> instances) {
    this.widget = widget;
    this.instances = instances;
  }
}
