/*
 * $Id$
 */
package csbase.client.facilities.algorithms.parameters;

import java.util.Map;

import csbase.logic.algorithms.AlgorithmVersionId;

/**
 * Essa classe representa os valores dos paramtros do fluxo de algoritmos que
 * podem ser preenchidos previamente, sem a interferncia do usurio. Para cada
 * algoritmo que faz parte do fluxo, pode-se associar um conjunto de valores de
 * parmetros a serem inicialmente preenchidos.
 * 
 * @author pizzol
 * 
 */
public class FlowParametersValues {
  /** Nome do fluxo de algoritmos */
  private String flowName;

  /** Identificador da verso do fluxo de algoritmos */
  private AlgorithmVersionId flowVersionId;

  /** Lista de valores dos parmetros dos algoritmos do fluxo */
  private Map<Integer, NodeParametersValues> parametersValuesList;

  /**
   * Obtm o nome do fluxo de algoritmos.
   * 
   * @return o nome do fluxo de algoritmos
   */
  public String getFlowName() {
    return flowName;
  }

  /**
   * Estabelece o nome do fluxo de algoritmos.
   * 
   * @param flowName nome do fluxo de algoritmos
   */
  public void setFlowName(String flowName) {
    this.flowName = flowName;
  }

  /**
   * Obtm o identificador da verso do fluxo de algoritmos.
   * 
   * @return o identificador da verso do fluxo de algoritmos
   */
  public AlgorithmVersionId getFlowVersionId() {
    return flowVersionId;
  }

  /**
   * Estabelece o identificador da verso do fluxo de algoritmos.
   * 
   * @param flowVersionId identificador da verso do fluxo de algoritmos
   */
  public void setFlowVersionId(AlgorithmVersionId flowVersionId) {
    this.flowVersionId = flowVersionId;
  }

  /**
   * Obtm uma lista com os valores dos parmetros a serem inicializados no
   * fluxo de algoritmos.
   * 
   * @return uma lista com os valores dos parmetros do fluxo
   */
  public Map<Integer, NodeParametersValues> getParametersValuesList() {
    return parametersValuesList;
  }

  /**
   * Altera a lista com os valores dos parmetros a serem inicializados no fluxo
   * de algoritmos.
   * 
   * @param parametersValuesList lista com os valores dos parmetros do fluxo
   */
  public void setParametersValuesList(
    Map<Integer, NodeParametersValues> parametersValuesList) {
    this.parametersValuesList = parametersValuesList;
  }

  /**
   * Construtor.
   * 
   * @param flowName nome do fluxo
   * @param flowVersionId identificador da verso do fluxo de algoritmos
   * @param parametersValuesList lista de valores dos parmetros dos algoritmos
   *        do fluxo
   */
  public FlowParametersValues(String flowName,
    AlgorithmVersionId flowVersionId,
    Map<Integer, NodeParametersValues> parametersValuesList) {
    this.flowName = flowName;
    this.flowVersionId = flowVersionId;
    this.parametersValuesList = parametersValuesList;
  }

}
