package csbase.client.util.csvpanel;

import csbase.client.util.event.IEvent;

/**
 * Notificao de exceo no painel de visualizao de arquivos CSV.
 * 
 * @author Tecgraf
 */
public class CSVExceptionNotification implements IEvent {

  /**
   * Exceo que gerou o evento.
   */
  private final Exception exception;

  /**
   * Mensagem de erro.
   */
  private final String message;

  /**
   * Obtm a {@link Exception} que gerou o evento.
   * 
   * @return a {@link Exception} que gerou o evento.
   */
  public Exception getException() {
    return exception;
  }

  /**
   * Obtm a mensagem de erro.
   * 
   * @return a mensagem de erro.
   */
  public String getMessage() {
    return message;
  }

  /**
   * Construtor.
   * 
   * @param exception a exceo que gerou o evento.
   * @param message mensagem de erro
   */
  protected CSVExceptionNotification(Exception exception, String message) {
    super();
    this.exception = exception;
    this.message = message;
  }

  /**
   * Construtor.
   * 
   * @param exception a exceo que gerou o evento.
   */
  protected CSVExceptionNotification(Exception exception) {
    this(exception, exception.getMessage());
  }

}
