/*
 * $Id: DirectoryChooserSelectionListener.java,v 1.2 2010/06/15 03:04:23 clinio
 * Exp $
 */
package csbase.client.util.filechooser;

import java.util.ArrayList;
import java.util.List;

import csbase.client.util.filechooser.filetablepanel.ClientFileTablePanel;
import csbase.client.util.filechooser.filetablepanel.ClientFileTableSelectionListener;
import csbase.client.util.filechooser.filters.ClientFileFilterInterface.Operation;
import csbase.logic.ClientFile;

/**
 * Listener de mouse
 * 
 * @author Tecgraf/PUC-Rio
 */
class ClientFileChooserSelectionListener implements
  ClientFileTableSelectionListener {

  /**
   * Chooser
   */
  final private ClientFileChooser chooser;

  /**
   * {@inheritDoc}
   */
  @Override
  public void selectionPerformed(ClientFileTablePanel panel,
    List<ClientFile> selectionList) {
    final ClientFileChooserType type = chooser.getSelectionType();
    switch (type) {
      case SAVE:
        handleSaveType(selectionList);
        break;
      case OPEN:
        handleOpenType(selectionList);
        break;
    }
  }

  /**
   * Tratador de modo SAVE
   * 
   * @param selectionList a lista.
   */
  private void handleSaveType(List<ClientFile> selectionList) {
    if (selectionList.size() == 0) {
      clearSelection();
      return;
    }

    final ClientFile selection = selectionList.get(0);

    boolean flag = false;

    if (chooser.getSelectedFilter().accept(selection, Operation.SELECTION)) {
      switch (chooser.getSelectionMode()) {
      case FILES_ONLY:
        if (!selection.isDirectory()) {
          flag = true;
        }
        break;
      case DIRECTORIES_ONLY:
        if (selection.isDirectory()) {
          flag = true;
        }
        break;
      default:
          String message = String.format("Modo invlido: %s.\n", chooser.getSelectionMode());
          throw new IllegalStateException(message);
      }
    }

    if (flag) {
      final List<ClientFile> uniq = new ArrayList<ClientFile>();
      uniq.add(selection);
      chooser.setChosenItens(uniq);
    }
    else {
      clearSelection();
    }
  }

  /**
   * Limpeza de seleo.
   */
  private void clearSelection() {
    final List<ClientFile> empty = new ArrayList<ClientFile>();
    chooser.setChosenItens(empty);
  }

  /**
   * Tratador de modo OPEN.
   * 
   * @param selectionList a lista
   */
  private void handleOpenType(List<ClientFile> selectionList) {
    List<ClientFile> realList = new ArrayList<ClientFile>();
    for (ClientFile file : selectionList) {
      if (chooser.getSelectedFilter().accept(file, Operation.SELECTION)) {
        switch (chooser.getSelectionMode()) {
        case FILES_ONLY:
          if (!file.isDirectory()) {
            realList.add(file);
          }
          break;
        case DIRECTORIES_ONLY:
          if (file.isDirectory()) {
            realList.add(file);
          }
          break;

        default:
            String message = String.format("Modo invlido: %s.\n", chooser.getSelectionMode());
            throw new IllegalStateException(message);
        }
      }
    }
    chooser.setChosenItens(realList);
  }

  /**
   * Construtor
   * 
   * @param chooser dilogo.
   */
  ClientFileChooserSelectionListener(ClientFileChooser chooser) {
    this.chooser = chooser;
  }
}
