/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AbstractVersionTreeNodeAction;
import csbase.client.desktop.LocalTask;
import csbase.client.desktop.RemoteTask;
import csbase.client.externalresources.ExternalResources;
import csbase.client.externalresources.LocalFile;
import csbase.client.externalresources.StandaloneLocalFile;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.SingletonFileChooser;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.FileInfo;
import csbase.logic.SyncRemoteFileChannel;
import csbase.logic.Utilities;
import csbase.util.FileSystemUtils;
import csbase.util.Unzip;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public abstract class AbstractExportFileAction
extends AbstractVersionTreeNodeAction {
    private final FileInfo source;

    public AbstractExportFileAction(VersionTree tree, String name, FileInfo file) {
        super(tree, name);
        this.source = file;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (FileSystemUtils.canRead()) {
            this.fileSystemExport();
        } else {
            this.appletExport(this.source);
        }
    }

    protected abstract void appletExport(FileInfo var1);

    protected abstract RemoteFileChannelInfo prepareDownload(FileInfo var1) throws RemoteException;

    private void fileSystemExport() {
        final LocalFile targetFile = this.getTargetFile();
        if (targetFile == null) {
            return;
        }
        if (targetFile.exists() && !this.confirmOverwrite(targetFile)) {
            return;
        }
        final RemoteFileChannelInfo info = this.getRequestInfo();
        if (info == null) {
            return;
        }
        LocalTask<Void> task = new LocalTask<Void>(){

            protected void performTask() throws Exception {
                SyncRemoteFileChannel channel = new SyncRemoteFileChannel(info);
                channel.open(true);
                long size = channel.getSize();
                OutputStream target = targetFile.getOutputStream(false);
                channel.syncTransferTo(0L, size, target);
                target.flush();
                target.close();
            }

            @Override
            protected void handleError(Exception error) {
                if (error instanceof IOException) {
                    error.printStackTrace();
                    StandardDialogs.showErrorDialog((Component)AbstractExportFileAction.this.getWindow(), (String)AbstractExportFileAction.this.getName(), (String)LNG.get((String)"algomanager.error.download_fatal"));
                    return;
                }
                super.handleError(error);
            }
        };
        String waitMsg = LNG.get((String)"algomanager.msg.download_wait");
        boolean exportResult = task.execute(this.getWindow(), this.getName(), waitMsg, false, true);
        if (exportResult && this.source.isDirectory()) {
            LocalTask<Void> unzipTask = new LocalTask<Void>(){

                protected void performTask() throws Exception {
                    AbstractExportFileAction.this.extractZipFile(targetFile);
                }

                @Override
                protected void handleError(Exception error) {
                    if (error instanceof IOException) {
                        StandardDialogs.showErrorDialog((Component)AbstractExportFileAction.this.getWindow(), (String)AbstractExportFileAction.this.getName(), (String)LNG.get((String)"algomanager.error.download.extract_zip_file"));
                        return;
                    }
                    super.handleError(error);
                }
            };
            String unzipWaitMsg = LNG.get((String)"algomanager.msg.unzip_wait");
            unzipTask.execute(this.getWindow(), this.getName(), unzipWaitMsg, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractZipFile(LocalFile zipLocalFile) throws IOException {
        File zipFile = new File(zipLocalFile.getAbsolutePath());
        try {
            Unzip unzip = new Unzip(zipFile);
            if (unzip.listZipEntries().isEmpty()) {
                String msg = String.format(LNG.get((String)"algomanager.error.unzip_io"), zipFile.getName());
                throw new IOException(msg);
            }
            unzip.decompress(zipFile.getParentFile(), true);
        }
        finally {
            FileUtils.delete((File)zipFile);
        }
    }

    private boolean confirmOverwrite(LocalFile targetFile) {
        try {
            String msg = String.format(LNG.get((String)"algomanager.msg.confirm.file_exists"), targetFile.getName());
            int answer = StandardDialogs.showYesNoDialog((Component)this.getWindow(), (String)this.getName(), (Object)msg);
            return answer == 0;
        }
        catch (IOException ex) {
            String msg = LNG.get((String)"algomanager.error.download_io");
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), msg, ex);
            return false;
        }
    }

    private LocalFile getTargetFile() {
        try {
            SingletonFileChooser chooser = SingletonFileChooser.getInstance();
            chooser.setMultiSelectionEnabled(false);
            int result = 1;
            if (!this.source.isDirectory()) {
                File suggestedFileName = new File(chooser.getCurrentDirectory() + File.separator + this.source.getName());
                chooser.setSelectedFile(suggestedFileName);
                chooser.setFileSelectionMode(0);
                result = chooser.showSaveDialog(this.getWindow());
            } else {
                chooser.setFileSelectionMode(1);
                result = chooser.showOpenDialog(this.getWindow());
            }
            File target = null;
            if (result == 0) {
                target = !this.source.isDirectory() ? new File(chooser.getSelectedFile().getAbsolutePath()) : new File(chooser.getSelectedFile() + File.separator + this.source.getName() + ".zip");
                return new StandaloneLocalFile(target);
            }
            return null;
        }
        catch (AccessControlException ex) {
            return null;
        }
    }

    private RemoteFileChannelInfo getRequestInfo() {
        RemoteTask<RemoteFileChannelInfo> task = new RemoteTask<RemoteFileChannelInfo>(){

            protected void performTask() throws Exception {
                this.setResult(AbstractExportFileAction.this.prepareDownload(AbstractExportFileAction.this.source));
            }
        };
        String waitMsg = LNG.get((String)"algomanager.msg.upload_wait");
        if (!task.execute(this.getWindow(), this.getName(), waitMsg, false, true)) {
            return null;
        }
        return (RemoteFileChannelInfo)task.getResult();
    }

    protected void export(Object algoId, String filePath, String dialogTitle) {
        if (ExternalResources.getInstance().isEnabled()) {
            String[] filePathArray = Utilities.splitProjectPath((String)filePath);
            String urlStr = AlgorithmManagementProxy.retrieveDownloadURL(algoId, filePathArray, this.getWindow());
            if (urlStr == null) {
                return;
            }
            try {
                URL url = new URL(urlStr);
                ExternalResources.getInstance().showDocument(url);
            }
            catch (Exception ex) {
                StandardErrorDialogs.showErrorDialog(this.getWindow(), dialogTitle, (Throwable)ex);
            }
        } else {
            StandardDialogs.showInfoDialog((Component)this.getWindow(), (String)dialogTitle, (Object)LNG.get((String)"algomanager.error.download_not_available"));
        }
    }

    protected String getSourcePath(FileInfo source) {
        String[] path = source.getPathAsArray();
        StringBuilder sourcePath = new StringBuilder();
        for (int i = 0; i < path.length; ++i) {
            if (i > 0) {
                sourcePath.append("/");
            }
            sourcePath.append(path[i]);
        }
        return sourcePath.toString();
    }
}

