/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectFileChooser;
import csbase.client.project.ProjectTreePath;
import csbase.client.project.tasks.GetChildFromNameTask;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;
import csbase.logic.filters.ProjectFileCompositeAndFilter;
import csbase.logic.filters.ProjectFileDirectoryFilter;
import csbase.logic.filters.ProjectFileNameFilter;
import csbase.logic.filters.ProjectFileTypeFilter;
import java.awt.Component;
import java.awt.Window;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public final class ProjectFileChooserSave
extends ProjectFileChooser {
    private static final String TITLE = LNG.get((String)"PRJ_FILE_CHOOSER_SAVE_TITLE");
    private final String forceExtension;

    public ProjectFileChooserSave(Window owner, CommonClientProject project, int mode) throws ClientException {
        this(owner, project, mode, null, null, null, false);
    }

    public ProjectFileChooserSave(Window owner, CommonClientProject project, int mode, String defaultFileType) throws ClientException {
        this(owner, project, mode, defaultFileType, null, null, false);
    }

    public ProjectFileChooserSave(Window owner, CommonClientProject project, int mode, String defaultFileType, String defaultName, String fileExtension, boolean useFilter) throws ClientException {
        this(owner, project, mode, defaultFileType, defaultName, null, fileExtension, useFilter);
    }

    public ProjectFileChooserSave(Window owner, CommonClientProject project, int mode, String defaultFileType, String defaultName, String[] currentDirectory, String fileExtension, boolean useFilter) throws ClientException {
        super(owner, TITLE, project, false, mode, defaultFileType, ProjectFileChooserSave.createVisualFilter(mode, false, null, new String[]{defaultFileType}), ProjectFileChooserSave.createSelectionFilter(mode, null, defaultFileType), true, defaultName, currentDirectory, useFilter);
        if (mode == 2) {
            throw new IllegalArgumentException("Erro: ProjectFileChooserSave n\u00e3o deve ser usado com modo = FILE_AND_DIRECTORY");
        }
        this.forceExtension = fileExtension;
        this.dialog.setVisible(true);
    }

    @Override
    protected ProjectFileFilter getSelectionFilter() {
        return ProjectFileChooserSave.createSelectionFilter(this.mode, null, null);
    }

    @Override
    protected ProjectFileFilter getSelectionFilter(String fileType) {
        return ProjectFileChooserSave.createSelectionFilter(this.mode, null, fileType);
    }

    @Override
    protected ProjectFileFilter getSelectionFilter(String nameFilter, String fileType) {
        return ProjectFileChooserSave.createSelectionFilter(this.mode, nameFilter, fileType);
    }

    private static ProjectFileFilter createSelectionFilter(int mode, String name, String fileType) {
        boolean useTypeFilter;
        if (mode == 0) {
            return ProjectFileChooserSave.createVisualFilter(mode, false, name, new String[]{fileType});
        }
        ProjectFileCompositeAndFilter andFilter = new ProjectFileCompositeAndFilter();
        andFilter.addChild((ProjectFileFilter)ProjectFileDirectoryFilter.getInstance());
        boolean useNameFilter = name != null && !name.isEmpty();
        boolean bl = useTypeFilter = fileType != null && !fileType.isEmpty();
        if (useNameFilter) {
            andFilter.addChild((ProjectFileFilter)new ProjectFileNameFilter(name));
        }
        if (useTypeFilter) {
            andFilter.addChild((ProjectFileFilter)new ProjectFileTypeFilter(fileType));
        }
        return andFilter;
    }

    @Override
    protected boolean handleAction() {
        ClientProjectFile selectedFile = this.getSelectedFile();
        if (this.mode == 1) {
            this.setSelection(selectedFile);
            return true;
        }
        String name = this.fileNameText.getText().trim();
        if (!ClientUtilities.isValidFileName(name)) {
            this.showFilenameError();
            return false;
        }
        ClientProjectFile targetDirectory = selectedFile.isDirectory() ? selectedFile : selectedFile.getParent();
        ClientProjectFile newFile = null;
        if (this.forceExtension != null) {
            name = FileUtils.addFileExtension((String)name, (String)this.forceExtension);
        }
        if ((newFile = GetChildFromNameTask.runTask(targetDirectory, name)) != null) {
            if (newFile.isDirectory()) {
                this.projectTree.setSelectedFile(newFile);
                return false;
            }
            if (this.confirmOverwrite(newFile)) {
                this.setSelection(newFile);
                return true;
            }
            return false;
        }
        this.setSelection(targetDirectory, name);
        return true;
    }

    private void setSelection(ClientProjectFile file) {
        this.selectedPaths = new ProjectTreePath[1];
        this.selectedPaths[0] = file != null ? new ProjectTreePath(file) : null;
    }

    private void setSelection(ClientProjectFile targetDirectory, String filename) {
        String[] dirPath = targetDirectory.getPath();
        String[] newPath = new String[dirPath.length + 1];
        System.arraycopy(dirPath, 0, newPath, 0, dirPath.length);
        newPath[newPath.length - 1] = filename;
        this.selectedPaths = new ProjectTreePath[1];
        this.selectedPaths[0] = new ProjectTreePath(newPath, targetDirectory);
    }

    private void showFilenameError() {
        StandardErrorDialogs.showErrorDialog((Window)this.dialog, TITLE, LNG.get((String)"PRJ_PROJECT_FILE_NAME_CHARACTERES_ERROR"));
    }

    private boolean confirmOverwrite(ClientProjectFile newFile) {
        if (newFile.isLocked()) {
            StandardDialogs.showErrorDialog((Component)this.dialog, (String)(LNG.get((String)"PRJ_FILE_CHOOSER_ERROR") + " - " + TITLE), (String)LNG.get((String)"PRJ_FILE_CHOOSER_OVERWRITE_LOCKED_FILE_ERROR"));
            return false;
        }
        int option = StandardDialogs.showYesNoDialog((Component)this.dialog, (String)(LNG.get((String)"PRJ_FILE_CHOOSER_INFO") + " - " + TITLE), (Object)LNG.get((String)"PRJ_FILE_CHOOSER_OVERWRITE_WARNING"));
        return option == 0;
    }

    public String getFileType() {
        if (!this.fileTypeList.hasSelectedTypeCode() || this.fileTypeList.isAllItemSelected()) {
            switch (this.mode) {
                case 0: {
                    return "UNKNOWN";
                }
                case 1: {
                    return "DIRECTORY_TYPE";
                }
            }
            String msg = String.format("Modo %s n\u00e3o suportado.", this.mode);
            throw new IllegalStateException(msg);
        }
        return this.fileTypeList.getSelectedTypeCode();
    }

    @Override
    protected void makeSelection(ClientProjectFile[] projectFileArray) {
        if (projectFileArray.length == 0) {
            this.fileNameText.setText("");
            this.selectedPaths = null;
        } else {
            ClientProjectFile selectedFile = projectFileArray[0];
            if (!selectedFile.isDirectory()) {
                this.fileNameText.setText(selectedFile.getName());
            }
            this.selectedPaths = new ProjectTreePath[]{new ProjectTreePath(selectedFile)};
        }
    }
}

