/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.logic.ProjectFileType;
import csbase.logic.ProjectFileTypeFilter;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import tecgraf.javautils.core.lng.LNG;

public final class ProjectFileTypeComboBox
extends JComboBox<Object> {
    private static final String ALL_FILES = LNG.get((String)"UTIL_ALL_FILES");
    private static final String ALL_DIRECTORIES = LNG.get((String)"UTIL_ALL_DIRECTORIES");
    private static final String ALL_FILES_AND_DIRECTORIES = LNG.get((String)"UTIL_ALL_FILES_AND_DIRECTORIES");
    private String allItem;

    public ProjectFileTypeComboBox(Mode mode, boolean useAllItem) {
        ProjectFileTypeFilter filter;
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        switch (mode) {
            case DIRECTORY_ONLY: {
                filter = ProjectFileTypeFilter.directories();
                break;
            }
            case FILE_ONLY: {
                filter = ProjectFileTypeFilter.files();
                break;
            }
            case FILE_AND_DIRECTORY: {
                filter = ProjectFileTypeFilter.all();
                break;
            }
            default: {
                String msg = String.format("Modo inv\u00e1lido: %s.", new Object[]{mode});
                throw new IllegalArgumentException(msg);
            }
        }
        for (ProjectFileType type : ProjectFileType.getFileTypes((ProjectFileTypeFilter)filter)) {
            model.addElement(type);
        }
        if (useAllItem) {
            switch (mode) {
                case DIRECTORY_ONLY: {
                    this.allItem = ALL_DIRECTORIES;
                    break;
                }
                case FILE_ONLY: {
                    this.allItem = ALL_FILES;
                    break;
                }
                case FILE_AND_DIRECTORY: {
                    this.allItem = ALL_FILES_AND_DIRECTORIES;
                    break;
                }
                default: {
                    String msg = String.format("Modo inv\u00e1lido: %s.", new Object[]{mode});
                    throw new IllegalArgumentException(msg);
                }
            }
            model.addElement(this.allItem);
        } else {
            this.allItem = null;
        }
        this.setModel(model);
        if (useAllItem) {
            this.selectAllItem();
        }
    }

    public boolean hasSelectedTypeCode() {
        return this.getSelectedIndex() != -1;
    }

    public boolean isAllItemSelected() {
        if (this.allItem == null) {
            return false;
        }
        if (!this.hasSelectedTypeCode()) {
            return false;
        }
        Object item = this.getSelectedItem();
        return item.equals(this.allItem);
    }

    public String getSelectedTypeCode() {
        if (!this.hasSelectedTypeCode()) {
            return null;
        }
        if (this.isAllItemSelected()) {
            return null;
        }
        ProjectFileType type = (ProjectFileType)this.getSelectedItem();
        return type.getCode();
    }

    public boolean selectTypeCode(String typeCode) {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            ProjectFileType type;
            Object element = this.getModel().getElementAt(i);
            if (!(element instanceof ProjectFileType) || !typeCode.equals((type = (ProjectFileType)element).getCode())) continue;
            this.setSelectedItem(type);
            return true;
        }
        return false;
    }

    public boolean selectAllItem() {
        if (this.allItem == null) {
            return false;
        }
        this.setSelectedItem(this.allItem);
        return true;
    }

    public static enum Mode {
        FILE_ONLY,
        DIRECTORY_ONLY,
        FILE_AND_DIRECTORY;

    }
}

