/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.client.algorithms.parameters;

import csbase.exception.ParseException;

/**
 * Campo de Texto para representar Nmeros Inteiros.
 *
 * @author lmoreira
 */
public class DoubleTextField extends NumberTextField<Double> {
  /**
   * Cria o campo.
   * 
   * @param errorValue o valor usado para indicar erro.
   */
  public DoubleTextField(Double errorValue) {
    this(new DefaultDoubleTextFieldModel(errorValue));
  }

  /**
   * Cria o campo.
   *
   * @param model O modelo (No aceita {@code null}).
   */
  public DoubleTextField(NumberTextFieldModel<Double> model) {
    super(model);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected String format(Double number) {
    return number.toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Double parse(String text) throws ParseException {
    try {
      return Double.parseDouble(text);
    }
    catch (NumberFormatException e) {
      throw new ParseException(
        "O texto informado no representa um nmero real.\n" + "Texto: ({0}).",
        text);
    }
  }
}
