package csbase.client.applications.algorithmsmanager.report.implementations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import csbase.client.applications.Application;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.remote.ClientRemoteLocator;

/**
 * Classe que cria e armazena um conjunto de parameters para ser usado como
 * source de um teste
 *
 * @author Tecgraf/PUC-Rio
 */
@SuppressWarnings("rawtypes")
public class ParameterSource implements Iterable<Class<? extends
  Parameter>> {

  /**
   * Lista de classes dos parmetros disponveis.
   */
  private final List<Class<? extends Parameter>> parameters;

  /**
   * Construtor
   *
   * @param app a aplicao
   */
  public ParameterSource(Application app) {
    RemoteTask<List<Class<? extends Parameter>>> task =
      new RemoteTask<List<Class<? extends Parameter>>>() {

      @Override
      protected void performTask() throws Exception {
        Map<String, ParameterFactory> factories =
          ClientRemoteLocator.algorithmService.getParameterFactories();
        List<Class<? extends Parameter>> params = new ArrayList<>();

        int i = 0;
        int n = factories.size();
        for (ParameterFactory factory : factories.values()) {
          setProgressStatus(i * 100 / n);
          params.addAll(factory.getParameterTypes());

          i++;
        }
        setResult(params);
      }
    };

    task.execute(app.getApplicationFrame(),
      app.getClassString(getClass(), "task.title"),
      app.getClassString(getClass(), "task.description"), true, false);

    if (task.getStatus()) {
      parameters = task.getResult();
    }
    else {
      parameters = new ArrayList<>();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Iterator<Class<? extends Parameter>> iterator() {
    return parameters.iterator();
  }

}
