package csbase.client.applications.fileexchanger.actions;

import java.util.ArrayList;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.actions.core.FileExchangerAction;
import csbase.client.applications.fileexchanger.logic.Exchange;
import csbase.client.applications.fileexchanger.logic.ExchangeState;

/**
 * Ao de deleo de opraes (<b>se terminadas</b>).
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DeleteAction extends FileExchangerAction {

  /**
   * Construtor
   * 
   * @param fileExchanger aplicao.
   */
  public DeleteAction(FileExchanger fileExchanger) {
    super(fileExchanger, ApplicationImages.ICON_DELETE_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() {
    final FileExchanger fileExchanger = getApplication();
    final ApplicationFrame frame = fileExchanger.getApplicationFrame();
    final ArrayList<Exchange> sels = fileExchanger.getSelectedExchangeList();
    if (sels.size() == 0) {
      final String title = getApplication().getName();
      final String err = getClassString("no.selection.error");
      StandardDialogs.showErrorDialog(frame, title, err);
      return;
    }

    int nsels = 0;
    for (Exchange sel : sels) {
      final ExchangeState state = sel.getState();
      if (state != ExchangeState.RUNNING) {
        nsels++;
        fileExchanger.delFromExchangeList(sel);
      }
    }

    // Avisa que no apagou transferncias em andamento.
    if (sels.size() != nsels) {
      final String err = getClassString("no.selection.running.error");
      StandardDialogs.showErrorDialog(frame, this.getApplication().getName(),
        err);
    }
  }

}
