package csbase.client.applications.jobmonitor.drivers;

import java.util.List;

import csbase.client.applications.Application;
import csbase.client.applications.jobmonitor.rowmodel.JobInfoRow;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import csbase.logic.SGASet;

/**
 * Driver usado para converter informaes de jobs em tabelas configurveis
 * usados na aplicao JobMonitor. <br>
 * 
 * Cada driver deve prver:<br>
 * - Uma tabela configurvel que exibe todas as informaes de jobs obtidas a
 * partir de uma lista de SGASets. <br>
 * - Uma lista de objetos do tipo {@code JobInfoRow}. <br>
 * 
 * @author Tecgraf
 */
public abstract class JobInfoDriver {

  /** Nome da propriedade que descreve o identificador de um job. */
  public final static String JOB_ID_PROPERTY = "Job_Id";

  /** Referncia para a aplicao. */
  protected Application application;

  /**
   * Construtor padro.
   * 
   * @param application - referncia para a aplicao.
   */
  protected JobInfoDriver(Application application) {
    this.application = application;
  }

  /**
   * Retorna a referncia para a aplicao
   * 
   * @return retorna a referncia para a aplicao
   */
  protected Application getApplication() {
    return application;
  }

  /**
   * Converte as informaes dos jobs coletadas e retorna uma lista de objetos
   * do tipo <code>JobInfoRows</code>.
   * 
   * @param sgas - SGASets que sero convertidos em uma lista de linhas.
   * @return lista de linhas.
   */
  public abstract List<JobInfoRow> getRows(List<SGASet> sgas);

  /**
   * Converte as informaes dos jobs em uma tabela configurvel.
   * 
   * @param sgas - string que contm a informao dos jobs.
   * @return tabela configurvel.
   */
  public abstract ConfigurableTable<JobInfoRow> getTable(List<SGASet> sgas);

}
