package csbase.client.applications.projectsmanager.panels.renderers;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import csbase.client.applications.projectsmanager.ProjectsManagerUI;

/**
 * Renderer da coluna de ocupao.
 * 
 * @author jnlopes
 * 
 */
public class TableOccupationRenderer extends DefaultTableCellRenderer {

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    final Component component =
      super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
        row, column);
    final JLabel label = (JLabel) component;
    label.setHorizontalAlignment(SwingConstants.RIGHT);
    if (value != null) {

      double occupation = (Double) value;
      if (occupation == -1) {
        label.setText(ProjectsManagerUI
          .getString("TableOccupationRenderer.not.loaded.message"));
        return label;
      }

      occupation = Math.round(occupation * 1000) / 1000.0;
      if (occupation < 1) {
        occupation = occupation * 1024;
        label.setText(String.valueOf(occupation) + " kb");
      }
      else if (occupation > 1024) {
        occupation = occupation / 1024;
        occupation = Math.round(occupation * 1000) / 1000.0;
        label.setText(String.valueOf(occupation) + " gb");
      }
      else {
        label.setText(String.valueOf(occupation) + " mb");
      }
    }
    else {
      label.setText(null);
    }

    return label;
  }

}
