/**
 * $Id: ValidationStatusListCellRenderer.java 140813 2013-05-10 15:15:06Z fpina
 * $
 */

package csbase.client.applications.serverdiagnostic.monitor;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingConstants;

import csbase.client.applications.ApplicationImages;
import csbase.logic.diagnosticservice.ValidationStatus;

/**
 * Renderer para desenhar um item em uma lista de status.
 * 
 * @author Tecgraf PUC-Rio
 */
public class ValidationStatusListCellRenderer extends DefaultListCellRenderer {
  /**
   * Construtor.
   */
  public ValidationStatusListCellRenderer() {
    setOpaque(true);
    setHorizontalAlignment(CENTER);
    setVerticalAlignment(CENTER);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getListCellRendererComponent(JList list, Object value,
    int index, boolean isSelected, boolean cellHasFocus) {
    JLabel label =
      (JLabel) super.getListCellRendererComponent(list, value, index,
        isSelected, cellHasFocus);
    ValidationStatus status = (ValidationStatus) value;
    Icon icon = getIcon(list, value, index, isSelected, cellHasFocus);
    label.setText(status.message);
    label.setIcon(icon);
    if (status.detailMessage != null) {
      label.setToolTipText("<html><p width=\"500\">" + status.detailMessage
        + "</p></html>");
    }
    label.setHorizontalAlignment(SwingConstants.LEADING);

    return label;
  }

  /**
   * Obtm o cone do {@link csbase.logic.diagnosticservice.ValidationStatus}.
   * 
   * @param list a lista
   * @param value o valor retornado por list.getModel().getElementAt (index)
   * @param index o ndice
   * @param isSelected indica se a clula est selecionada
   * @param cellHasFocus indica se a clula est com o foco
   * 
   * @return o cone do {@link csbase.logic.diagnosticservice.ValidationStatus}
   */
  private Icon getIcon(JList list, Object value, int index, boolean isSelected,
    boolean cellHasFocus) {
    switch (((ValidationStatus) value).code) {
      case OK:
        return ApplicationImages.GREEN_BALL_16;
      case WARNING:
        return ApplicationImages.YELLOW_BALL_16;
      case ERROR:
      case UNAVAILABLE:
      case INITIATING:
        return ApplicationImages.RED_BALL_16;
      default:
        return null;
    }
  }
}
