package csbase.client.facilities.configurabletable.column;

import java.util.Comparator;

import tecgraf.javautils.gui.table.IColumn;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;

/**
 * Coluna que possui um identificador nico e que tambm  possvel definir a
 * sua visibilidade.
 * 
 * @see ConfigurableTable ConfigurableTableModel
 * @param <T> - tipo do dado que  exibido pela coluna.
 * 
 * @author Tecgraf
 * 
 */
public interface IConfigurableColumn<T> extends IColumn<T> {

  /**
   * Identificador nico da coluna.
   * 
   * @return identificador nico da coluna.
   */
  String getId();

  /**
   * Diz se a coluna  visvel.
   * 
   * @return <code>true</code> se a coluna for visvel, <code>false</code> caso
   *         contrrio.
   */
  boolean isVisible();

  /**
   * Define a visibilidade da coluna.
   * 
   * @param visible - <code>true</code> se a coluna for visvel,
   *        <code>false</code> caso contrrio.
   */
  void setVisible(boolean visible);

  /**
   * Obtm o alinhamento dos valores da tabela.
   * 
   * @return alinhamento dos valores da tabela.
   */
  int getAlign();

  /**
   * Retorna um comparador exclusivo da coluna.
   * 
   * @return comparador exclusivo da coluna.
   */
  Comparator<?> getComparator();

}
