/**
 * $Id$
 */
package csbase.client.util;

import java.awt.Window;
import java.util.List;
import java.util.Set;

import csbase.client.applications.projectsmanager.usersearch.UserDialog;
import csbase.client.applications.projectsmanager.usersearch.UserPanel;
import csbase.logic.UserOutline;

/**
 * Dilogo de escolha de permisses por usurio para shared object.
 * 
 * @author Tecgraf
 */
public class SharedObjectUserDialog extends UserDialog {

  /**
   * Construtor.
   * 
   * @param owner - janela-me
   * @param allUsers - lista com todos os usurios disponveis para
   *        compartilhamento
   * @param showPermissions Boolean que indica que o esquema de permisses deve
   *        ser exibido.
   * @param confirmation Boolean que indica que a visualizao do dilogo exige
   *        uma resposta ("confirmar" / "cancelar") do usurio.
   */
  public SharedObjectUserDialog(Window owner, List<UserOutline> allUsers,
    boolean showPermissions, boolean confirmation) {
    super(owner, allUsers, showPermissions, confirmation);
  }

  /**
   * Construtor.
   * 
   * @param owner - janela-me
   * @param allUsers - lista com todos os usurios disponveis para
   *        compartilhamento
   * @param usersRO Usurios com permisso de leitura.
   * @param usersRW Usurios com permisso de leitura e escrita.
   * @param showPermissions Boolean que indica que o esquema de permisses deve
   *        ser exibido.
   * @param confirmation Boolean que indica que a visualizao do dilogo exige
   *        uma resposta ("confirmar" / "cancelar") do usurio.
   */
  public SharedObjectUserDialog(Window owner, List<UserOutline> allUsers,
    Set<Object> usersRO, Set<Object> usersRW, boolean showPermissions,
    boolean confirmation) {
    super(owner, allUsers, usersRO, usersRW, showPermissions, confirmation);
  }

  /**
   * Construtor.
   * 
   * @param owner - janela-me
   * @param allUsers - lista com todos os usurios disponveis para
   *        compartilhamento
   * @param usersRO Usurios com permisso de leitura.
   * @param usersRW Usurios com permisso de leitura e escrita.
   * @param showPermissions Boolean que indica que o esquema de permisses deve
   *        ser exibido.
   * @param confirmation Boolean que indica que a visualizao do dilogo exige
   *        uma resposta ("confirmar" / "cancelar") do usurio.
   * @param fixedAccess Indica se os usurios so todos membros ou no-membros
   *        dos projetos.
   */
  public SharedObjectUserDialog(Window owner, List<UserOutline> allUsers,
    Set<Object> usersRO, Set<Object> usersRW, boolean showPermissions,
    boolean confirmation, boolean fixedAccess) {
    super(owner, allUsers, usersRO, usersRW, showPermissions, confirmation,
      fixedAccess);
  }

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  protected UserPanel getUserPanel(List<UserOutline> allUsers,
    Set<Object> usersRO, final Set<Object> usersRW, boolean showPermissions,
    boolean fixedAccess) {
    return new SharedObjectUserPanel(allUsers, usersRO, usersRW,
      showPermissions, fixedAccess);
  }

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  protected UserPanel getUserPanel(List<UserOutline> allUsers,
    Set<Object> usersRO, final Set<Object> usersRW, boolean showPermissions) {
    return new SharedObjectUserPanel(allUsers, usersRO, usersRW,
      showPermissions);
  }

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  protected UserPanel getUserPanel(List<UserOutline> allUsers,
    boolean showPermissions) {
    return new SharedObjectUserPanel(allUsers, showPermissions);
  }

  /**
   * Retorna true se e somente se, o usurio escolheu leitura permitida para
   * todos os usurios
   * 
   * @return true se e somente se, o usurio escolheu leitura permitida para
   *         todos os usurios
   */
  public boolean isGlobal() {
    return ((SharedObjectUserPanel) userPanel).isGlobal();
  }

  /**
   * Atribui o valor de permisso para todos os usurios apropriadamente
   * 
   * @param isGlobal booleano que indica se todos os usurios tem acesso global
   *        ao objeto.
   */
  public void setGlobal(boolean isGlobal) {
    ((SharedObjectUserPanel) userPanel).setGlobal(isGlobal);
  }
}
